/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SqxxCommitEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.commit.SqxxCommitResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqxxCommitDomainService {
    private static final Logger log = LoggerFactory.getLogger(SqxxCommitDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Autowired
    GxYySqlxJdxxZtRepository sqlxJdxxZtRepository;
    @Autowired
    private Map<String, SqxxCommitEventService> eventServiceMap;

    public SqxxCommitResultModel event(SqxxCommitParamsModel paramsModel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{paramsModel.getLysjdm(), paramsModel.getProcessId()})) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List sqxxList = this.sqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList)) {
            throw new BizException(ApplyCodeEnum.APPLY_SQXX_NULL.getCode(), ApplyCodeEnum.APPLY_SQXX_NULL.getMsg());
        }
        paramsModel.setGxYySqxxList(sqxxList);
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), JddmEnum.JDDM_BDJS_1002.getCode(), paramsModel.getAnid(), ((GxYySqxx)sqxxList.get(0)).getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SqxxCommitResultModel resultModel = new SqxxCommitResultModel();
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                SqxxCommitEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
            this.sqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1001.getCode());
            this.sqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1002.getCode());
        }
        catch (BizException e) {
            log.error("\u7533\u8bf7\u4fe1\u606f\u63d0\u4ea4\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1001.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1002.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return resultModel;
    }
}

