/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SqxxBatchSaveEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.SqxxBatchSaveModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.util.thread.ThreadPoolMdcExecutor;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class SqxxBatchSaveOrUpdateDomainService {
    private static final Logger log = LoggerFactory.getLogger(SqxxBatchSaveOrUpdateDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYySqxxRepository sqxxRepository;
    @Resource
    private Map<String, SqxxBatchSaveEventService> eventServiceMap;

    public void event(final SqxxBatchSaveModel paramsModel) {
        List sqxxList = this.sqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList)) {
            throw new BizException(ApplyCodeEnum.APPLY_SQXX_NULL.getCode(), ApplyCodeEnum.APPLY_SQXX_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getJddm(), paramsModel.getAnid(), paramsModel.getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        try {
            final List lydzList = lysjList.getLydzList();
            ThreadPoolTaskExecutor executor = ThreadPoolMdcExecutor.taskExecutor();
            final CountDownLatch latch = new CountDownLatch(lydzList.size());
            Callable call = new Callable(){

                public Object call() {
                    try {
                        for (GxYyLydz lydz : lydzList) {
                            SqxxBatchSaveEventService eventService = (SqxxBatchSaveEventService)SqxxBatchSaveOrUpdateDomainService.this.eventServiceMap.get(lydz.getLydzsxl());
                            eventService.doWork(paramsModel);
                        }
                    }
                    catch (Exception e) {
                        log.error("SqxxBatchSaveOrUpdateDomainService", (Throwable)e);
                        if (e.getCause() instanceof BizException) {
                            throw (BizException)e.getCause();
                        }
                        throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), e.getMessage());
                    }
                    finally {
                        latch.countDown();
                    }
                    return null;
                }
            };
            try {
                Future future = executor.submit(call);
                future.get();
            }
            catch (ExecutionException e) {
                log.error("SqxxBatchSaveOrUpdateDomainService", (Throwable)e);
                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), e.getMessage());
            }
            catch (InterruptedException e) {
                log.error("SqxxBatchSaveOrUpdateDomainService", (Throwable)e);
                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), e.getMessage());
            }
        }
        catch (BizException e) {
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
    }
}

