/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SqxxAuditEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.audit.SqxxAuditParamsModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SqxxAuditDomainService {
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, SqxxAuditEventService> eventServiceMap;

    public void event(SqxxAuditParamsModel sqxxAuditModel) {
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(sqxxAuditModel.getLysjdm(), sqxxAuditModel.getProcessId(), sqxxAuditModel.getAnid());
        if (CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SqxxAuditEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(sqxxAuditModel);
        }
    }
}

