/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.SlztEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.slzt.SlztUpdateParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.slzt.SlztUpdateResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlztUpdateDomainService {
    private static final Logger log = LoggerFactory.getLogger(SlztUpdateDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Autowired
    GxYySqlxJdxxZtRepository sqlxJdxxZtRepository;
    @Autowired
    GxYySqlxJdxxLysjRelRepository jdxxLysjRelRepository;
    @Autowired
    private Map<String, SlztEventService> eventServiceMap;

    public SlztUpdateResultModel event(SlztUpdateParamsModel paramsModel) {
        List sqxxList = this.sqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList)) {
            throw new BizException(ApplyCodeEnum.APPLY_SQXX_NULL.getCode(), ApplyCodeEnum.APPLY_SQXX_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getJddm(), paramsModel.getAnid(), ((GxYySqxx)sqxxList.get(0)).getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SlztUpdateResultModel resultModel = new SlztUpdateResultModel();
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                SlztEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
        }
        catch (BizException e) {
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return resultModel;
    }

    private List<GxYyLydz> getProcessLysdz(String processId, String lysjdm) {
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(lysjdm, processId);
        if (lysjModel == null) {
            return null;
        }
        return lysjModel.getLydzList();
    }

    private List<GxYyLydz> getJddmLysdz(String jddm, String lysjdm, String sqlx) {
        JdxxLysjModel jdxxLysjModel = this.jdxxLysjRelRepository.queryLysjAndLydz(jddm, sqlx, lysjdm);
        if (jdxxLysjModel == null) {
            return null;
        }
        return jdxxLysjModel.getLydzList();
    }
}

