/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.QlrHqEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.qlr.QlrHqParamsModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QlrHqDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Autowired
    private Map<String, QlrHqEventService> eventServiceMap;

    public void event(QlrHqParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List<Object> lydzList = Lists.newArrayList();
        lydzList = StringUtils.isNotBlank((CharSequence)paramsModel.getProcessId()) ? this.getProcessLydz(paramsModel) : this.getJdxxLydz(paramsModel);
        if (CollectionUtils.isEmpty((Collection)lydzList)) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        for (GxYyLydz gxYyLydz : lydzList) {
            QlrHqEventService eventService = this.eventServiceMap.get(gxYyLydz.getLydzsxl());
            eventService.doWork(paramsModel);
        }
    }

    private List<GxYyLydz> getProcessLydz(QlrHqParamsModel paramsModel) {
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return lysjModel.getLydzList();
    }

    private List<GxYyLydz> getJdxxLydz(QlrHqParamsModel paramsModel) {
        JdxxLysjModel jdxxLysjModel = this.sqlxJdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm());
        if (jdxxLysjModel == null || CollectionUtils.isEmpty((Collection)jdxxLysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return jdxxLysjModel.getLydzList();
    }
}

