/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.PushSwhyEventService;
import cn.gtmap.hlw.core.dto.sqxx.push.PushSqxxDjParamsDTO;
import cn.gtmap.hlw.core.dto.sqxx.push.PushSqxxDjResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PushSwhyDomainService {
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, PushSwhyEventService> eventServiceMap;

    public PushSqxxDjResultDTO event(PushSqxxDjParamsDTO paramsDTO) {
        if (StringUtils.isBlank((CharSequence)paramsDTO.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsDTO.getLysjdm(), paramsDTO.getProcessId(), paramsDTO.getAnid());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        PushSqxxDjResultDTO resultDTO = new PushSqxxDjResultDTO();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            PushSwhyEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsDTO, resultDTO);
        }
        return resultDTO;
    }
}

