/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.PushSqxxEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.push.PushSqxxEventResultModel;
import cn.gtmap.hlw.core.domain.sqxx.model.push.PushSqxxParamsModel;
import cn.gtmap.hlw.core.domain.sqxx.model.push.PushSqxxResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.dict.SlztEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYyProcessLysjRel;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushSqxxDjDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Autowired
    GxYySqlxJdxxZtRepository sqlxJdxxZtRepository;
    @Resource
    private GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Autowired
    private Map<String, PushSqxxEventService> eventServiceMap;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private RedisRepository redisRepository;

    public PushSqxxResultModel event(PushSqxxParamsModel paramsModel) {
        LysjModel lysjList;
        GxYyProcessLysjRel gxYyProcessLysjRel;
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)paramsModel.getProcessId()) && StringUtils.isBlank((CharSequence)paramsModel.getAnid()) && (gxYyProcessLysjRel = this.gxYyProcessLysjRelRepository.getByLysjdmAndSqlx(paramsModel.getLysjdm(), paramsModel.getSqlx())) != null) {
            paramsModel.setProcessId(gxYyProcessLysjRel.getProcessId());
        }
        if ((lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), JddmEnum.JDDM_SH_TSDJ.getCode(), paramsModel.getAnid(), paramsModel.getSqlx())) == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            this.delPushRedis(paramsModel.getSlbh(), "");
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        PushSqxxResultModel resultModel = new PushSqxxResultModel();
        boolean tsSuccess = true;
        try {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                PushSqxxEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                PushSqxxEventResultModel eventResultModel = eventService.doWork(paramsModel, resultModel);
                if (eventResultModel == null || !eventResultModel.getSfzdlydz().booleanValue()) continue;
                tsSuccess = false;
                break;
            }
        }
        catch (BizException e) {
            this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_SH_TSDJ.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            this.delPushRedis(paramsModel.getSlbh(), "");
            if (StringUtils.equals((CharSequence)e.getIError().getCode(), (CharSequence)ApplyCodeEnum.APPLY_SLZT_PUSHING.getCode())) {
                this.delPushRedis(paramsModel.getSlbh(), "");
            } else {
                this.delPushRedis(paramsModel.getSlbh(), paramsModel.getSlzt());
            }
            throw e;
        }
        catch (Exception e) {
            this.sqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_SH_TSDJ.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            this.delPushRedis(paramsModel.getSlbh(), paramsModel.getSlzt());
            throw e;
        }
        if (tsSuccess) {
            this.sqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_SH_TSDJ.getCode());
        }
        return resultModel;
    }

    private void delPushRedis(String slbh, String slzt) {
        GxYySqxx sqxx;
        String key = "pushDjSlbh:" + slbh;
        this.redisRepository.del(new String[]{key});
        if (StringUtils.isNotBlank((CharSequence)slzt) && StringUtils.equals((CharSequence)String.valueOf((sqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(slbh)).getSlzt()), (CharSequence)SlztEnum.SLZT_TSZ.getCode())) {
            this.gxYySqxxRepository.updateSlzt(slbh, slzt);
        }
    }
}

