/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sqxx.event;

import cn.gtmap.hlw.core.domain.sqxx.GeneratePdfEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.pdf.GeneratePdfResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GeneratePdfDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, GeneratePdfEventService> eventServiceMap;
    @Resource
    private HlwPzPzxRepository hlwPzPzxRepository;

    public List<GeneratePdfResultModel> event(GeneratePdfParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), null);
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        String qydm = StringUtils.isNotBlank((CharSequence)paramsModel.getQydm()) ? paramsModel.getQydm() : this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("register.dwdm");
        paramsModel.setQydm(qydm);
        ArrayList resultModelList = Lists.newArrayList();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            GeneratePdfEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, (List)resultModelList);
        }
        return resultModelList;
    }
}

