/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event.create.wxbl;

import cn.gtmap.hlw.core.constant.sign.SignConstants;
import cn.gtmap.hlw.core.domain.sign.SignFlowCommonService;
import cn.gtmap.hlw.core.domain.sign.SignFlowsCreateEventService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateDataParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateFjxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjQsxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateDataResultModel;
import cn.gtmap.hlw.core.dto.sign.create.result.SignFlowsCreateDataResultDTO;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.dict.sign.QsrlbEnum;
import cn.gtmap.hlw.core.enums.dict.sign.SignCsdmEnum;
import cn.gtmap.hlw.core.enums.dict.sign.SignQsfsEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyLcdyPzRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignFlowsCreateAssembleFjWxblEvent
implements SignFlowsCreateEventService {
    private static final Logger logger = LoggerFactory.getLogger(SignFlowsCreateAssembleFjWxblEvent.class);
    @Resource
    private GxYyLcdyPzRepository gxYyLcdyPzRepository;
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private GxYyFjxmRepository gxYyFjxmRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private RedisRepository redisRepository;
    @Resource
    private SignFlowCommonService signFlowCommonService;
    private static final String FJLX = String.valueOf(FjlxEnum.FJLX_WXBL.getCode());
    private static final String FJLXMC = String.valueOf(FjlxEnum.FJLX_WXBL.getMsg());

    public String getEventFjlx() {
        return FJLX;
    }

    public SignFlowsCreateDataResultDTO doWork(SignFlowsCreateParamsModel paramsModel, SignFlowsCreateDataResultModel resultModel) {
        logger.info("SignFlowsCreateAssembleFjWxblEvent-->doWork:\u5f00\u59cb\u7ec4\u88c5\u95ee\u8be2\u7b14\u5f55");
        SignFlowsCreateDataParamsModel signFlowsCreateDataParamsModel = paramsModel.getData();
        List qsrxxList = signFlowsCreateDataParamsModel.getQsrxxList();
        List fjxxList = signFlowsCreateDataParamsModel.getFjxxList();
        if (CollectionUtils.isNotEmpty((Collection)qsrxxList)) {
            for (int i = 0; i < qsrxxList.size(); ++i) {
                SignFlowsCreateQsrxxParamsModel signFlowsCreateQsrxxParamsModel = (SignFlowsCreateQsrxxParamsModel)qsrxxList.get(i);
                List<SignFlowsCreateQsrxxQswjParamsModel> qswjList = signFlowsCreateQsrxxParamsModel.getQswjList() == null ? new ArrayList() : signFlowsCreateQsrxxParamsModel.getQswjList();
                GxYyLcdyPz gxYyLcdyPz = this.getGxYyLcdyPz(paramsModel, signFlowsCreateQsrxxParamsModel.getQlrlx());
                logger.info("SignFlowsCreateAssembleFjWxblEvent-->doWork:\u95ee\u8be2\u7b14\u5f55gxYyLcdyPz:{}", (Object)JSON.toJSONString((Object)gxYyLcdyPz));
                if (gxYyLcdyPz == null) continue;
                SignFlowsCreateQsrxxQswjParamsModel qsrxxQswjParamsModel = new SignFlowsCreateQsrxxQswjParamsModel();
                List<SignFlowsCreateQsrxxQswjQsxxParamsModel> qsxxList = this.getQsxxList(paramsModel, gxYyLcdyPz, signFlowsCreateQsrxxParamsModel, i);
                logger.info("SignFlowsCreateAssembleFjWxblEvent-->doWork:paramsModel:{}", (Object)JSON.toJSONString((Object)paramsModel));
                SignFlowsCreateFjxxParamsModel fjxx = this.getSignFlowsCreateFjxxParamsModel(paramsModel, gxYyLcdyPz.getWjmc());
                qsrxxQswjParamsModel.setFjid(fjxx.getFjid());
                if (StringUtils.isBlank((CharSequence)fjxx.getFjid())) {
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u7ec4\u88c5\u4e91\u7b7e\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9644\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u9644\u4ef6\u540d\u79f0\u4e3a\uff1a" + FJLXMC);
                }
                fjxxList.add(fjxx);
                signFlowsCreateDataParamsModel.setFjxxList(fjxxList);
                qsrxxQswjParamsModel.setQsxxList(qsxxList);
                qswjList.add(qsrxxQswjParamsModel);
                signFlowsCreateQsrxxParamsModel.setQswjList(qswjList);
            }
            Boolean isExists = this.signFlowCommonService.isExistsYqFjlx(fjxxList, FJLX);
            if (!isExists.booleanValue()) {
                throw new BizException(ErrorEnum.FJ_PARAM_NULL.getCode(), "\u672a\u627e\u5230\u4e91\u7b7e\u9644\u4ef6\u540d\u79f0\uff1a" + FJLXMC + ",\u9644\u4ef6\u7c7b\u578b\u4ee3\u7801\uff1a" + FJLX);
            }
        }
        return null;
    }

    private SignFlowsCreateFjxxParamsModel getSignFlowsCreateFjxxParamsModel(SignFlowsCreateParamsModel paramsModel, String wjmc) {
        SignFlowsCreateFjxxParamsModel fjxx = new SignFlowsCreateFjxxParamsModel();
        GxYyFjxm gxYyFjxm = this.gxYyFjxmRepository.getBySlbhAndFjlx(paramsModel.getSlbh(), FJLX);
        if (gxYyFjxm != null) {
            List gxYyFjxxList = this.gxYyFjxxRepository.getByFjxmid(gxYyFjxm.getXmid());
            if (CollectionUtils.isEmpty((Collection)gxYyFjxxList)) {
                throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u53d1\u8d77\u4e91\u7b7e\uff0c\u672a\u83b7\u53d6\u5230\u95ee\u8be2\u7b14\u5f55\u9644\u4ef6,\u8bf7\u68c0\u67e5\u95ee\u8be2\u7b14\u5f55\u9644\u4ef6\u662f\u5426\u5df2\u751f\u6210\uff01");
            }
            logger.info("SignFlowsCreateAssembleFjWxblEvent-->doWork:gxYyFjxxList:{}", (Object)JSON.toJSONString((Object)gxYyFjxxList));
            for (GxYyFjxx gxYyFjxx : gxYyFjxxList) {
                if (!gxYyFjxx.getFjmc().startsWith(wjmc)) continue;
                fjxx.setSqid(gxYyFjxx.getSqid());
                fjxx.setFjid(gxYyFjxx.getFjid());
                fjxx.setFjmc(gxYyFjxx.getFjmc());
                fjxx.setFjlx(FJLX);
                fjxx.setQssx("1");
                String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
                fjxx.setFjxzdz(uploadPath + File.separator + gxYyFjxx.getFilepath() + File.separator + fjxx.getFjmc());
            }
        }
        if (fjxx == null || StringUtils.isBlank((CharSequence)fjxx.getFjid())) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u53d1\u8d77\u4e91\u7b7e\uff0c\u672a\u83b7\u53d6\u5230" + wjmc + "\u9644\u4ef6,\u8bf7\u68c0\u67e5+" + wjmc + "\u9644\u4ef6\u662f\u5426\u5df2\u751f\u6210\uff01");
        }
        return fjxx;
    }

    private List<SignFlowsCreateQsrxxQswjQsxxParamsModel> getQsxxList(SignFlowsCreateParamsModel paramsModel, GxYyLcdyPz gxYyLcdyPz, SignFlowsCreateQsrxxParamsModel qsrxxParamsModel, int index) {
        ArrayList<SignFlowsCreateQsrxxQswjQsxxParamsModel> qsxxList = new ArrayList<SignFlowsCreateQsrxxQswjQsxxParamsModel>();
        SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx = new SignFlowsCreateQsrxxQswjQsxxParamsModel();
        qsxx.setWidth(gxYyLcdyPz.getQsqk());
        qsxx.setQslx(SignConstants.QSLX_GJZ_DM);
        qsxx.setKey("\u7b7e\u5b57\u533a_" + qsrxxParamsModel.getZjh());
        qsxx.setKeyIndex("-1");
        qsxx = this.signFlowCommonService.setPosXy(qsxx, gxYyLcdyPz, Integer.valueOf(index));
        qsxx.setQswzlx("PERSON");
        if (QsrlbEnum.QSRLB_GR.getDm().equals(qsrxxParamsModel.getQsrlb())) {
            qsxx.setQsfs(SignQsfsEnum.QSFS_GRMZ.getDm());
        } else if (QsrlbEnum.QSFS_QY.getDm().equals(qsrxxParamsModel.getQsrlb())) {
            qsxx.setQsfs(SignQsfsEnum.QSFS_DZFDMCZ.getDm());
        }
        if (SignCsdmEnum.CSDM_ESIGN_KSBL.getDm().equals(paramsModel.getCsdm())) {
            qsxx.setQsfs("1");
        }
        qsxx.setHeight("120");
        qsxxList.add(qsxx);
        return qsxxList;
    }

    private GxYyLcdyPz getGxYyLcdyPz(SignFlowsCreateParamsModel paramsModel, String qlrlx) {
        GeneratePdfParamsModel generatePdfParamsModel = new GeneratePdfParamsModel();
        generatePdfParamsModel.setSqlx(paramsModel.getSqlx());
        generatePdfParamsModel.setFjlx(FJLX);
        generatePdfParamsModel.setQydm(paramsModel.getQydm());
        generatePdfParamsModel.setQlrlx(qlrlx);
        GxYyLcdyPz gxYyLcdyPz = this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
        return gxYyLcdyPz;
    }
}

