/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event.create.sqs;

import cn.gtmap.hlw.core.constant.sign.SignConstants;
import cn.gtmap.hlw.core.domain.sign.SignFlowCommonService;
import cn.gtmap.hlw.core.domain.sign.SignFlowsCreateEventService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateDataParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateFjxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjQsxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateDataResultModel;
import cn.gtmap.hlw.core.dto.sign.create.result.SignFlowsCreateDataResultDTO;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.dict.sign.QsrlbEnum;
import cn.gtmap.hlw.core.enums.dict.sign.SignCsdmEnum;
import cn.gtmap.hlw.core.enums.dict.sign.SignQsfsEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyLcdyPzRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.sqxx.event.pdf.PdfGenerateCheckUtils;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignFlowsCreateAssembleAhBdcdjSqsfsEvent
implements SignFlowsCreateEventService {
    private static final Logger logger = LoggerFactory.getLogger(SignFlowsCreateAssembleAhBdcdjSqsfsEvent.class);
    @Resource
    private GxYyLcdyPzRepository gxYyLcdyPzRepository;
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private GxYyFjxmRepository gxYyFjxmRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private RedisRepository redisRepository;
    @Resource
    private PdfGenerateCheckUtils pdfGenerateCheckUtils;
    @Resource
    private SignFlowCommonService signFlowCommonService;
    private static final String FJLX = String.valueOf(FjlxEnum.FJLX_ZYSQS.getCode());
    private static final String FJLXMC = String.valueOf(FjlxEnum.FJLX_ZYSQS.getMsg());

    public String getEventFjlx() {
        return FJLX;
    }

    public SignFlowsCreateDataResultDTO doWork(SignFlowsCreateParamsModel paramsModel, SignFlowsCreateDataResultModel resultModel) {
        logger.error("\u5f00\u59cb\u7ec4\u88c5{}", (Object)FJLX);
        SignFlowsCreateDataParamsModel signFlowsCreateDataParamsModel = paramsModel.getData();
        List qsrxxList = signFlowsCreateDataParamsModel.getQsrxxList();
        List fjxxList = signFlowsCreateDataParamsModel.getFjxxList();
        if (CollectionUtils.isNotEmpty((Collection)qsrxxList)) {
            for (int i = 0; i < qsrxxList.size(); ++i) {
                SignFlowsCreateQsrxxParamsModel signFlowsCreateQsrxxParamsModel = (SignFlowsCreateQsrxxParamsModel)qsrxxList.get(i);
                List<SignFlowsCreateQsrxxQswjParamsModel> qswjList = signFlowsCreateQsrxxParamsModel.getQswjList() == null ? new ArrayList() : signFlowsCreateQsrxxParamsModel.getQswjList();
                GxYyLcdyPz gxYyLcdyPz = this.pdfGenerateCheckUtils.pdf907Check(paramsModel.getSlbh(), signFlowsCreateQsrxxParamsModel.getQlrlx(), paramsModel.getQydm());
                logger.error("{},\u6d41\u7a0b\u6253\u5370\u914d\u7f6e,{}", (Object)FJLX, (Object)JSON.toJSONString((Object)gxYyLcdyPz));
                if (gxYyLcdyPz == null) continue;
                SignFlowsCreateQsrxxQswjParamsModel qsrxxQswjParamsModel = new SignFlowsCreateQsrxxQswjParamsModel();
                List<SignFlowsCreateQsrxxQswjQsxxParamsModel> qsxxList = this.getQsxxList(paramsModel, gxYyLcdyPz, signFlowsCreateQsrxxParamsModel, i);
                SignFlowsCreateFjxxParamsModel fjxx = this.getSignFlowsCreateFjxxParamsModel(paramsModel);
                qsrxxQswjParamsModel.setFjid(fjxx.getFjid());
                if (StringUtils.isBlank((CharSequence)fjxx.getFjid())) {
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u7ec4\u88c5\u4e91\u7b7e\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9644\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u9644\u4ef6\u540d\u79f0\u4e3a\uff1a" + FJLXMC);
                }
                signFlowsCreateDataParamsModel.setFjxxList(fjxxList);
                qsrxxQswjParamsModel.setQsxxList(qsxxList);
                fjxxList.add(fjxx);
                qswjList.add(qsrxxQswjParamsModel);
                signFlowsCreateQsrxxParamsModel.setQswjList(qswjList);
            }
        }
        return null;
    }

    private List<SignFlowsCreateQsrxxQswjQsxxParamsModel> getQsxxList(SignFlowsCreateParamsModel paramsModel, GxYyLcdyPz gxYyLcdyPz, SignFlowsCreateQsrxxParamsModel qsrxxParamsModel, Integer index) {
        ArrayList<SignFlowsCreateQsrxxQswjQsxxParamsModel> qsxxList = new ArrayList<SignFlowsCreateQsrxxQswjQsxxParamsModel>();
        SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx = new SignFlowsCreateQsrxxQswjQsxxParamsModel();
        qsxx.setWidth(gxYyLcdyPz.getQsqk());
        qsxx.setQslx(SignConstants.QSLX_GJZ_DM);
        qsxx.setKey("\u7b7e\u5b57\u533a_" + qsrxxParamsModel.getZjh());
        qsxx.setKeyIndex("-1");
        qsxx = this.signFlowCommonService.setPosXy(qsxx, gxYyLcdyPz, index);
        qsxx.setQswzlx("PERSON");
        if (QsrlbEnum.QSRLB_GR.getDm().equals(qsrxxParamsModel.getQsrlb())) {
            qsxx.setQsfs(SignQsfsEnum.QSFS_GRMZ.getDm());
        } else if (QsrlbEnum.QSFS_QY.getDm().equals(qsrxxParamsModel.getQsrlb())) {
            qsxx.setQsfs(SignQsfsEnum.QSFS_DZFDMCZ.getDm());
        }
        if (SignCsdmEnum.CSDM_ESIGN_KSBL.getDm().equals(paramsModel.getCsdm())) {
            qsxx.setQsfs("1");
        }
        qsxx.setHeight("120");
        qsxxList.add(qsxx);
        return qsxxList;
    }

    private SignFlowsCreateFjxxParamsModel getSignFlowsCreateFjxxParamsModel(SignFlowsCreateParamsModel paramsModel) {
        SignFlowsCreateFjxxParamsModel fjxx = new SignFlowsCreateFjxxParamsModel();
        GxYyFjxm gxYyFjxm = this.gxYyFjxmRepository.getBySlbhAndFjlx(paramsModel.getSlbh(), FJLX);
        if (gxYyFjxm == null) {
            return null;
        }
        List gxYyFjxxList = this.gxYyFjxxRepository.getByFjxmid(gxYyFjxm.getXmid());
        if (CollectionUtils.isEmpty((Collection)gxYyFjxxList)) {
            return null;
        }
        GxYyFjxx gxYyFjxx = (GxYyFjxx)gxYyFjxxList.get(0);
        if (gxYyFjxx != null) {
            fjxx.setSqid(gxYyFjxx.getSqid());
            fjxx.setFjid(gxYyFjxx.getFjid());
            fjxx.setFjmc(gxYyFjxx.getFjmc());
            fjxx.setFjlx(FJLX);
            fjxx.setQssx("1");
            String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
            fjxx.setFjxzdz(uploadPath + File.separator + gxYyFjxx.getFilepath() + File.separator + fjxx.getFjmc());
        }
        return fjxx;
    }

    private GxYyLcdyPz getGxYyLcdyPz(SignFlowsCreateParamsModel paramsModel, String qlrlx) {
        String djyy = "";
        GxYySqxx sqxx = this.gxYySqxxRepository.getSqxxZyBySlbh(paramsModel.getSlbh());
        if (sqxx != null) {
            djyy = sqxx.getDjyy();
        }
        GeneratePdfParamsModel generatePdfParamsModel = new GeneratePdfParamsModel();
        generatePdfParamsModel.setSqlx(paramsModel.getSqlx());
        generatePdfParamsModel.setFjlx(FJLX);
        generatePdfParamsModel.setQydm(paramsModel.getQydm());
        generatePdfParamsModel.setDjyy(djyy);
        generatePdfParamsModel.setQlrlx(qlrlx);
        GxYyLcdyPz gxYyLcdyPz = this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
        return gxYyLcdyPz;
    }
}

