/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event.create;

import cn.gtmap.hlw.core.base.UserInfo;
import cn.gtmap.hlw.core.constant.sign.SignConstants;
import cn.gtmap.hlw.core.domain.sign.SignFlowCommonService;
import cn.gtmap.hlw.core.domain.sign.SignFlowsCreateEventService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateBoardParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateDataParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateFjxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjQsxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateSignParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateDataResultModel;
import cn.gtmap.hlw.core.dto.sign.create.result.SignFlowsCreateDataResultDTO;
import cn.gtmap.hlw.core.enums.dict.ZjlxEnum;
import cn.gtmap.hlw.core.enums.dict.sign.QsrlbEnum;
import cn.gtmap.hlw.core.enums.dict.sign.SignQsfsEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjYq;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.GxYySqxxYq;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyFjYqRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyLcdyPzRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxYqRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.file.FileUtils;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignFlowsCreateAssembleQmPdfCombineEvent
implements SignFlowsCreateEventService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowsCreateAssembleQmPdfCombineEvent.class);
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private GxYyLcdyPzRepository gxYyLcdyPzRepository;
    @Resource
    private GxYySqxxYqRepository gxYySqxxYqRepository;
    @Resource
    private GxYyFjYqRepository gxYyFjYqRepository;
    @Resource
    private RedisRepository redisRepository;
    @Resource
    private SignFlowCommonService signFlowCommonService;
    private static final Integer AHCA_WIDTH = 80;

    public String getEventFjlx() {
        return null;
    }

    public SignFlowsCreateDataResultDTO doWork(SignFlowsCreateParamsModel paramsModel, SignFlowsCreateDataResultModel resultModel) {
        log.info("pdf\u7b7e\u540d\u5408\u5e76\u6570\u636e\u7ec4\u88c5\u4e8b\u4ef6\u5f00\u59cb\u6267\u884c:{}", (Object)JSON.toJSONString((Object)paramsModel));
        UserInfo userInfo = SessionUtil.getUser();
        if (userInfo == null) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4eba");
        }
        List<GxYyFjYq> gxYyFjYqList = this.getYyFjYqList(paramsModel.getSlbh());
        if (StringUtils.isBlank((CharSequence)paramsModel.getSlbh()) || CollectionUtils.isEmpty(gxYyFjYqList)) {
            this.handleLcwSign(paramsModel, userInfo);
        } else {
            this.handleLcnSign(paramsModel, gxYyFjYqList);
        }
        log.info("pdf\u7b7e\u540d\u5408\u5e76\u6570\u636e\u7ec4\u88c5\u4e8b\u4ef6\u6267\u884c\u7ed3\u675f,qsrxxList:{}", (Object)JSON.toJSONString((Object)paramsModel.getData().getQsrxxList()));
        return null;
    }

    private void handleLcnSign(SignFlowsCreateParamsModel paramsModel, List<GxYyFjYq> gxYyFjYqList) {
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        SignFlowsCreateBoardParamsModel createBoardParamsModel = (SignFlowsCreateBoardParamsModel)paramsModel.getSignBoardList().get(0);
        String qsrzjh = ((SignFlowsCreateSignParamsModel)createBoardParamsModel.getSignList().get(0)).getZjh();
        String qsrQm = ((SignFlowsCreateSignParamsModel)createBoardParamsModel.getSignList().get(0)).getSignAndFpBase64();
        Map<String, List<GxYyFjYq>> fjYqListMap = gxYyFjYqList.stream().collect(Collectors.groupingBy(GxYyFjYq::getQlrzjh));
        ArrayList newQsrxxList = Lists.newArrayList();
        for (SignFlowsCreateQsrxxParamsModel qsrxxParamsModel : paramsModel.getData().getQsrxxList()) {
            List qsxxList;
            ArrayList qsrxxQswjParamsModelList = Lists.newArrayList();
            List<GxYyFjYq> gxYyFjYqs = fjYqListMap.get(qsrxxParamsModel.getZjh());
            log.info("gxYyFjYqs:{}", (Object)JSON.toJSONString(gxYyFjYqs));
            if (CollectionUtils.isNotEmpty(gxYyFjYqs)) {
                for (GxYyFjYq gxYyFjYq : gxYyFjYqs) {
                    GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(gxYyFjYq.getFjid());
                    GxYyLcdyPz gxYyLcdyPz = this.getGxYyLcdyPz(paramsModel, gxYyFjxx.getFjlx(), qsrxxParamsModel.getQlrlx());
                    log.info("gxYyLcdyPz:{}", (Object)JSON.toJSONString((Object)gxYyLcdyPz));
                    ArrayList qswjQsxxParamsModels = Lists.newArrayList();
                    SignFlowsCreateQsrxxQswjParamsModel qswjParamsModel = new SignFlowsCreateQsrxxQswjParamsModel();
                    String signAndFpBase64 = FileUtils.getFjBase64((String)(uploadPath + File.separator + gxYyFjYq.getImgpath()), (String)"");
                    if (StringUtils.equals((CharSequence)gxYyFjYq.getQlrzjh(), (CharSequence)qsrzjh)) {
                        signAndFpBase64 = qsrQm;
                    }
                    SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx = this.getQsxxParamsModel(gxYyFjYq.getQlrzjh(), signAndFpBase64, gxYyLcdyPz);
                    qswjParamsModel.setFjid(gxYyFjYq.getFjid());
                    qswjQsxxParamsModels.add(qsxx);
                    qswjParamsModel.setQsxxList((List)qswjQsxxParamsModels);
                    qsrxxQswjParamsModelList.add(qswjParamsModel);
                    qsrxxParamsModel.setQswjList((List)qsrxxQswjParamsModelList);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)qsrxxParamsModel.getQswjList()) || !CollectionUtils.isNotEmpty((Collection)(qsxxList = ((SignFlowsCreateQsrxxQswjParamsModel)qsrxxParamsModel.getQswjList().get(0)).getQsxxList())) || !StringUtils.isNotBlank((CharSequence)((SignFlowsCreateQsrxxQswjQsxxParamsModel)qsxxList.get(0)).getQsimg())) continue;
            newQsrxxList.add(qsrxxParamsModel);
        }
        paramsModel.getData().setQsrxxList((List)newQsrxxList);
    }

    private void handleLcwSign(SignFlowsCreateParamsModel paramsModel, UserInfo userInfo) {
        SignFlowsCreateDataParamsModel signFlowsCreateDataParamsModel = paramsModel.getData();
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        if (CollectionUtils.isNotEmpty((Collection)paramsModel.getSignBoardList())) {
            List qsrxxList = paramsModel.getData().getQsrxxList();
            ArrayList fjxxParamsModelList = Lists.newArrayList();
            if (CollectionUtils.isEmpty((Collection)paramsModel.getSignBoardList())) {
                return;
            }
            SignFlowsCreateBoardParamsModel createBoardParamsModel = (SignFlowsCreateBoardParamsModel)paramsModel.getSignBoardList().get(0);
            if (CollectionUtils.isEmpty((Collection)createBoardParamsModel.getSignList())) {
                return;
            }
            SignFlowsCreateSignParamsModel signParamsModel = (SignFlowsCreateSignParamsModel)createBoardParamsModel.getSignList().get(0);
            GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(signParamsModel.getFjid());
            GxYyLcdyPz gxYyLcdyPz = this.getGxYyLcdyPz(paramsModel, gxYyFjxx.getFjlx(), "");
            log.info("gxYyLcdyPz:{}", (Object)JSON.toJSONString((Object)gxYyLcdyPz));
            String base64Str = FileUtils.getFjBase64((String)(uploadPath + File.separator + gxYyFjxx.getFilepath()), (String)gxYyFjxx.getFjmc());
            SignFlowsCreateFjxxParamsModel fjxxParamsModel = new SignFlowsCreateFjxxParamsModel();
            fjxxParamsModel.setFjBase64(base64Str);
            fjxxParamsModel.setFjid(gxYyFjxx.getFjid());
            fjxxParamsModel.setFjmc(gxYyFjxx.getFjmc());
            fjxxParamsModel.setFjxzdz(uploadPath + File.separator + gxYyFjxx.getFilepath() + File.separator + fjxxParamsModel.getFjmc());
            fjxxParamsModelList.add(fjxxParamsModel);
            signFlowsCreateDataParamsModel.setFjxxList((List)fjxxParamsModelList);
            signFlowsCreateDataParamsModel.setSlbh(signFlowsCreateDataParamsModel.getLsh());
            if (StringUtils.isBlank((CharSequence)signFlowsCreateDataParamsModel.getLsh())) {
                signFlowsCreateDataParamsModel.setSlbh(StringUtil.hex32());
            }
            SignFlowsCreateQsrxxParamsModel qsrxxParamsModel = new SignFlowsCreateQsrxxParamsModel();
            ArrayList qsrxxQswjParamsModelList = Lists.newArrayList();
            SignFlowsCreateQsrxxQswjParamsModel qswjParamsModel = new SignFlowsCreateQsrxxQswjParamsModel();
            ArrayList qswjQsxxParamsModels = Lists.newArrayList();
            SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx = this.getQsxxParamsModel(signParamsModel.getZjh(), signParamsModel.getSignAndFpBase64(), gxYyLcdyPz);
            qswjQsxxParamsModels.add(qsxx);
            qswjParamsModel.setFjid(gxYyFjxx.getFjid());
            qswjParamsModel.setQsxxList((List)qswjQsxxParamsModels);
            qsrxxQswjParamsModelList.add(qswjParamsModel);
            qsrxxParamsModel.setXm(userInfo.getRealName());
            qsrxxParamsModel.setQmsx(Integer.valueOf(1));
            qsrxxParamsModel.setZjh(userInfo.getUserZjid());
            qsrxxParamsModel.setLxdh(userInfo.getLxDh());
            qsrxxParamsModel.setZjlx(StringUtils.isNotBlank((CharSequence)userInfo.getZjType()) ? userInfo.getZjType() : ZjlxEnum.SFZJZL_SFZ.getCode());
            qsrxxParamsModel.setQsrlb(QsrlbEnum.QSRLB_GR.getDm());
            qsrxxParamsModel.setQswjList((List)qsrxxQswjParamsModelList);
            qsrxxList.add(qsrxxParamsModel);
            signFlowsCreateDataParamsModel.setQsrxxList(qsrxxList);
        }
    }

    private List<GxYyFjYq> getYyFjYqList(String slbh) {
        List gxYySqxxYqList = this.gxYySqxxYqRepository.getBySlbh(slbh);
        if (CollectionUtils.isNotEmpty((Collection)gxYySqxxYqList)) {
            return this.gxYyFjYqRepository.list(((GxYySqxxYq)gxYySqxxYqList.get(0)).getQsrwid());
        }
        return Lists.newArrayList();
    }

    @NotNull
    private SignFlowsCreateQsrxxQswjQsxxParamsModel getQsxxParamsModel(String qlrzjh, String qsimg, GxYyLcdyPz gxYyLcdyPz) {
        SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx = new SignFlowsCreateQsrxxQswjQsxxParamsModel();
        qsxx.setQsfs(SignQsfsEnum.QSFS_GRMZ.getDm());
        qsxx.setQslx(SignConstants.QSLX_GJZ_DM);
        qsxx.setQsy("1");
        if (StringUtils.isNotBlank((CharSequence)qlrzjh)) {
            qsxx.setKey("\u7b7e\u5b57\u533a_" + qlrzjh);
        } else {
            qsxx.setKey("\u627f\u8bfa\u4eba");
        }
        qsxx.setHeight(String.valueOf(AHCA_WIDTH / 2));
        qsxx.setWidth(String.valueOf(AHCA_WIDTH));
        qsxx.setPosX("0");
        qsxx.setPosY("0");
        if (gxYyLcdyPz != null) {
            qsxx = this.signFlowCommonService.setPosXy(qsxx, gxYyLcdyPz, Integer.valueOf(0));
            String width = gxYyLcdyPz.getQsqk();
            if (StringUtils.isNotBlank((CharSequence)width)) {
                qsxx.setWidth(width);
                qsxx.setHeight(String.valueOf(Integer.parseInt(width) / 2));
            }
        }
        qsimg = qsimg.replace("data:image/png;base64,", "");
        qsxx.setQswzlx("PERSON");
        qsxx.setQsimg(qsimg);
        return qsxx;
    }

    private GxYyLcdyPz getGxYyLcdyPz(SignFlowsCreateParamsModel paramsModel, String fjlx, String qlrlx) {
        GeneratePdfParamsModel generatePdfParamsModel = new GeneratePdfParamsModel();
        generatePdfParamsModel.setSqlx(paramsModel.getSqlx());
        generatePdfParamsModel.setFjlx(fjlx);
        generatePdfParamsModel.setQlrlx(qlrlx);
        generatePdfParamsModel.setQydm(paramsModel.getQydm());
        return this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
    }
}

