/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event.board;

import cn.gtmap.hlw.core.domain.sign.SignBoardStartEventService;
import cn.gtmap.hlw.core.domain.sign.model.query.params.SignBoardStartMuParaDataResultModel;
import cn.gtmap.hlw.core.domain.sign.model.query.params.SignBoardStartParaDataResultModel;
import cn.gtmap.hlw.core.domain.sign.model.query.params.SignBoardStartParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.query.params.SignBoardStartResultModel;
import cn.gtmap.hlw.core.enums.dict.ZjlxEnum;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.status.BoolenEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyLcdyPzRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignBoardQueryQswjxxEvent
implements SignBoardStartEventService {
    private static final Logger log = LoggerFactory.getLogger(SignBoardQueryQswjxxEvent.class);
    @Resource
    private GxYyLcdyPzRepository gxYyLcdyPzRepository;
    @Resource
    private GxYyFjxmRepository gxYyFjxmRepository;
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYyQlrRepository gxYyQlrRepository;
    @Resource
    private HlwPzPzxRepository hlwPzPzxRepository;
    private static final String TYPE = "1";
    private static final String SIGN_WIDTH = "100";
    private static final String LINE_WIDTH = "40";
    private static final String FP_WIDTH = "256";
    private static final Integer MAX_X = 499;
    private static final Integer MAX_Y = 809;

    public void doWork(SignBoardStartParamsModel paramsModel, SignBoardStartResultModel resultModel) {
        ArrayList qswjxxList = Lists.newArrayList();
        SignBoardStartMuParaDataResultModel muParaDataResultModel = new SignBoardStartMuParaDataResultModel();
        List gxYyFjxmList = this.gxYyFjxmRepository.getBySlbh(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)gxYyFjxmList)) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u9644\u4ef6\u9879\u76ee\u4fe1\u606f");
        }
        List xmidList = gxYyFjxmList.stream().map(GxYyFjxm::getXmid).collect(Collectors.toList());
        List gxYyFjxxList = this.gxYyFjxxRepository.getByFjxmids(xmidList);
        if (CollectionUtils.isEmpty((Collection)gxYyFjxxList)) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u9644\u4ef6\u4fe1\u606f");
        }
        GxYySqxx gxYySqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
        if (gxYySqxx == null) {
            throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u7533\u8bf7\u4fe1\u606f");
        }
        GeneratePdfParamsModel generatePdfParamsModel = new GeneratePdfParamsModel();
        generatePdfParamsModel.setSqlx(gxYySqxx.getSqlx());
        generatePdfParamsModel.setQydm(gxYySqxx.getQydm());
        generatePdfParamsModel.setDjyy(gxYySqxx.getDjyy());
        ArrayList pdfPathList = Lists.newArrayList();
        String webUrl = paramsModel.getWebUrl().replaceAll("https", "http");
        int fileIndex = 0;
        HashSet compareNameSet = Sets.newHashSet();
        for (int i = 0; i < gxYyFjxxList.size(); ++i) {
            boolean sfqz = false;
            GxYyFjxx gxYyFjxx = (GxYyFjxx)gxYyFjxxList.get(i);
            if (!gxYyFjxx.getFjmc().contains(".pdf")) continue;
            generatePdfParamsModel.setFjlx(gxYyFjxx.getFjlx());
            List gxYyQlrList = Lists.newArrayList();
            if (FjlxEnum.FJLX_WXBL.getCode().toString().equals(gxYyFjxx.getFjlx())) {
                if (gxYyFjxx.getFjmc().contains(QlrTypeEnum.QLRLX_QLR.getMsg())) {
                    gxYyQlrList = this.gxYyQlrRepository.getBySqidAndQlrlx(gxYyFjxx.getSqid(), QlrTypeEnum.QLRLX_QLR.getCode());
                } else if (gxYyFjxx.getFjmc().contains(QlrTypeEnum.QLRLX_YWR.getMsg())) {
                    gxYyQlrList = this.gxYyQlrRepository.getBySqidAndQlrlx(gxYyFjxx.getSqid(), QlrTypeEnum.QLRLX_YWR.getCode());
                }
            } else {
                gxYyQlrList = this.gxYyQlrRepository.list(gxYyFjxx.getSqid());
            }
            String attributeStr = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("sign.flow.attribute");
            if (CollectionUtils.isNotEmpty((Collection)gxYyQlrList)) {
                for (int i1 = 0; i1 < gxYyQlrList.size(); ++i1) {
                    Float posY;
                    Float posX;
                    GxYyQlr gxYyQlr = (GxYyQlr)gxYyQlrList.get(i1);
                    generatePdfParamsModel.setQlrlx(gxYyQlr.getQlrlx());
                    generatePdfParamsModel.setSfsyqzb(TYPE);
                    GxYyLcdyPz gxYyLcdyPz = this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
                    log.info("gxYyLcdyPz:{}", (Object)JSON.toJSONString((Object)gxYyLcdyPz));
                    if (gxYyLcdyPz == null) continue;
                    sfqz = true;
                    SignBoardStartParaDataResultModel qswjxxResultModel = new SignBoardStartParaDataResultModel();
                    if (StringUtils.isNotBlank((CharSequence)attributeStr)) {
                        qswjxxResultModel = (SignBoardStartParaDataResultModel)JSON.parseObject((String)attributeStr, SignBoardStartParaDataResultModel.class);
                    } else {
                        qswjxxResultModel.setSignWidth(SIGN_WIDTH);
                        qswjxxResultModel.setLineWidth(LINE_WIDTH);
                        qswjxxResultModel.setFpWidth(FP_WIDTH);
                    }
                    qswjxxResultModel.setFileInde(Integer.valueOf(fileIndex));
                    qswjxxResultModel.setFjid(gxYyFjxx.getFjid());
                    if (StringUtils.equals((CharSequence)ZjlxEnum.SFZJZL_TYSHXYDM.getCode(), (CharSequence)gxYyQlr.getQlrsfzjzl()) || StringUtils.equals((CharSequence)ZjlxEnum.SFZJZL_YYZZ.getCode(), (CharSequence)gxYyQlr.getQlrsfzjzl()) || StringUtils.equals((CharSequence)ZjlxEnum.SFZJZL_ZHJGDM.getCode(), (CharSequence)gxYyQlr.getQlrsfzjzl())) {
                        qswjxxResultModel.setSingName(gxYyQlr.getDlrmc());
                    } else {
                        qswjxxResultModel.setSingName(gxYyQlr.getQlrmc());
                    }
                    compareNameSet.add(qswjxxResultModel.getSingName());
                    String x = gxYyLcdyPz.getX();
                    String y = gxYyLcdyPz.getY();
                    int indexX = i1 % 3;
                    int indexY = i1 / 3;
                    if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getX())) {
                        x = gxYyLcdyPz.getX();
                        if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbX())) {
                            posX = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getX()) + Float.parseFloat(gxYyLcdyPz.getSyzbX()) * (float)indexX);
                            x = String.format("%.0f", posX);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbX())) {
                        posX = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getSyzbX()) * (float)indexX);
                        x = String.valueOf(String.format("%.0f", posX));
                    }
                    if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getY())) {
                        y = gxYyLcdyPz.getY();
                        if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbY())) {
                            posY = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getY()) + Float.parseFloat(gxYyLcdyPz.getSyzbY()) * (float)indexY);
                            y = String.valueOf(String.format("%.0f", posY));
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbY())) {
                        posY = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getSyzbY()) * (float)indexY);
                        y = String.format("%.0f", posY);
                    }
                    if (Integer.parseInt(x) > MAX_X) {
                        x = String.valueOf(MAX_X);
                    }
                    if (Integer.parseInt(y) > MAX_Y) {
                        y = String.valueOf(MAX_Y);
                    }
                    qswjxxResultModel.setLocation("2," + gxYyLcdyPz.getQzym() + ',' + x + ',' + y);
                    qswjxxList.add(qswjxxResultModel);
                }
            }
            if (!sfqz) continue;
            ++fileIndex;
            pdfPathList.add(webUrl + "/fjxx/preview/" + gxYyFjxx.getFjid());
        }
        if (CollectionUtils.isNotEmpty((Collection)pdfPathList)) {
            resultModel.setPdfPath(StringUtils.join((Iterable)pdfPathList, (String)"|"));
        }
        muParaDataResultModel.setType(TYPE);
        muParaDataResultModel.setIsFaceCompare(BoolenEnum.TRUE.getMsg());
        muParaDataResultModel.setCompareNames(StringUtils.join((Iterable)compareNameSet, (String)"|"));
        muParaDataResultModel.setParaData((List)qswjxxList);
        log.info("muParaDataResultModel:{}", (Object)JSON.toJSONString((Object)muParaDataResultModel));
        resultModel.setMuParaData(muParaDataResultModel);
    }
}

