/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event;

import cn.gtmap.hlw.core.domain.sign.SignFlowsResultEventService;
import cn.gtmap.hlw.core.domain.sign.model.result.SignFlowsDataParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.result.SignFlowsResultDataResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SignFlowsResultDomainService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowsResultDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Resource
    private Map<String, SignFlowsResultEventService> eventServiceMap;

    public SignFlowsResultDataResultModel event(SignFlowsDataParamsModel paramsModel) {
        LysjModel lysjModel;
        log.info("SignFlowsDataParamsModel:{}", (Object)JSON.toJSONString((Object)paramsModel));
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List<Object> lydzList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getProcessId()) || StringUtils.isBlank((CharSequence)paramsModel.getJddm())) {
            lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getJddm(), paramsModel.getAnid(), paramsModel.getSqlx());
            if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
                throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
            }
            lydzList = lysjModel.getLydzList();
        } else if (StringUtils.isNotBlank((CharSequence)paramsModel.getJddm())) {
            lydzList = this.getJdxxLydz(paramsModel);
        }
        if (CollectionUtils.isEmpty((Collection)lydzList)) {
            lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), null);
            lydzList = lysjModel.getLydzList();
        }
        log.info("lydzList:{}", (Object)JSON.toJSONString((Object)lydzList));
        if (CollectionUtils.isEmpty((Collection)lydzList)) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SignFlowsResultDataResultModel resultModel = new SignFlowsResultDataResultModel();
        for (GxYyLydz gxYyLydz : lydzList) {
            SignFlowsResultEventService eventService = this.eventServiceMap.get(gxYyLydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }

    private List<GxYyLydz> getJdxxLydz(SignFlowsDataParamsModel paramsModel) {
        JdxxLysjModel jdxxLysjModel = this.sqlxJdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm(), paramsModel.getAnid());
        if (jdxxLysjModel == null || CollectionUtils.isEmpty((Collection)jdxxLysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return jdxxLysjModel.getLydzList();
    }
}

