/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event;

import cn.gtmap.hlw.core.domain.sign.SignFlowsCreateEventService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateDataParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateDataResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SignFlowsJdxxCreateDomainService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowsJdxxCreateDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Resource
    private Map<String, SignFlowsCreateEventService> eventServiceMap;

    public SignFlowsCreateDataResultModel event(SignFlowsCreateParamsModel paramsModel) {
        SignFlowsCreateDataParamsModel signFlowsCreateDataParamsModel = new SignFlowsCreateDataParamsModel();
        signFlowsCreateDataParamsModel.setFjxxList(new ArrayList());
        signFlowsCreateDataParamsModel.setQsrxxList(new ArrayList());
        paramsModel.setData(signFlowsCreateDataParamsModel);
        paramsModel.setFileList(new ArrayList());
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List<GxYyLydz> lydzList = StringUtils.isNotBlank((CharSequence)paramsModel.getProcessId()) ? this.getProcessLydz(paramsModel) : (StringUtils.isNotBlank((CharSequence)paramsModel.getJddm()) ? this.getJdxxLydz(paramsModel) : this.getProcessLydz(paramsModel));
        SignFlowsCreateDataResultModel resultModel = new SignFlowsCreateDataResultModel();
        log.info("\u4e91\u7b7e\u53d1\u8d77lydzList:{}", (Object)JSON.toJSONString(lydzList));
        for (GxYyLydz lydz : lydzList) {
            SignFlowsCreateEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            if (eventService == null && lydz.getLydzsxl().contains(";")) continue;
            eventService.doWork(paramsModel, resultModel);
            if (paramsModel.getSfzd() == null || !paramsModel.getSfzd().booleanValue()) continue;
            log.info("\u7531\u4e8e\u9886\u57df\u52a8\u4f5c{}\u901a\u77e5\uff0c\u540e\u7eed\u52a8\u4f5c\u5df2\u7ec8\u6b62\u6267\u884c", (Object)lydz.getLydzsxl());
            break;
        }
        return resultModel;
    }

    private List<GxYyLydz> getProcessLydz(SignFlowsCreateParamsModel paramsModel) {
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return lysjModel.getLydzList();
    }

    private List<GxYyLydz> getJdxxLydz(SignFlowsCreateParamsModel paramsModel) {
        JdxxLysjModel jdxxLysjModel = this.sqlxJdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm());
        if (jdxxLysjModel == null || CollectionUtils.isEmpty((Collection)jdxxLysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return jdxxLysjModel.getLydzList();
    }
}

