/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event;

import cn.gtmap.hlw.core.domain.sign.SignFlowsCreateEventService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateBoardParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateSignParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateDataResultModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateFjxxResultModel;
import cn.gtmap.hlw.core.dto.sign.create.result.SignFlowsCreateDataResultDTO;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYyProcessLysjRel;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyLcdyPzRepository;
import cn.gtmap.hlw.core.repository.GxYyLydzRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.file.FileUtils;
import cn.gtmap.hlw.core.util.file.PdfSigner;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignFlowsCreateYcCombinePdfEvent
implements SignFlowsCreateEventService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowsCreateYcCombinePdfEvent.class);
    @Resource
    private GxYyLcdyPzRepository gxYyLcdyPzRepository;
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private GxYyFjxmRepository gxYyFjxmRepository;
    @Resource
    private RedisRepository redisRepository;
    @Resource
    private GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Resource
    private GxYyLydzRepository gxYyLydzRepository;
    @Autowired
    private Map<String, SignFlowsCreateEventService> eventServiceMap;

    public String getEventFjlx() {
        return null;
    }

    public SignFlowsCreateDataResultDTO doWork(SignFlowsCreateParamsModel paramsModel, SignFlowsCreateDataResultModel resultModel) {
        log.info("\u4e00\u7a97\u672c\u5730\u5408\u5e76pdf\u4e0e\u7b7e\u540d\u56fe\u7247\u5f00\u59cb\u6267\u884c");
        log.info("paramsModel\uff1a{}", (Object)JSON.toJSONString((Object)paramsModel));
        GxYyProcessLysjRel gxYyProcessLysjRel = this.gxYyProcessLysjRelRepository.getByLysjdm(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (gxYyProcessLysjRel == null) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9886\u57df\u4e8b\u4ef6\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5gx_yy_process_lysj_rel\u6570\u636e");
        }
        String lydzListStr = gxYyProcessLysjRel.getLydzdmlist();
        log.info("lydzListStr:{}", (Object)lydzListStr);
        if (StringUtils.isBlank((CharSequence)lydzListStr)) {
            throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u8282\u70b9\u914d\u7f6e\u4e0b\u7684\u9886\u57df\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> signFjlxList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getSignFjlx())) {
            signFjlxList = Arrays.asList(paramsModel.getSignFjlx().split(","));
        } else {
            List<String> lydzList = Arrays.asList(lydzListStr.split(","));
            for (String string : lydzList) {
                GxYyLydz gxYyLydz = this.gxYyLydzRepository.get(string);
                if (gxYyLydz == null || this.getClass().getSimpleName().equalsIgnoreCase(gxYyLydz.getLydzsxl()) || this.eventServiceMap.containsKey(gxYyLydz.getLydzsxl())) continue;
                signFjlxList.add(gxYyLydz.getLydzsxl());
            }
        }
        log.info("signFjlxList:{}", (Object)JSON.toJSONString((Object)signFjlxList));
        ArrayList gxYyLcdyPzsList = Lists.newArrayList();
        for (String string : signFjlxList) {
            GeneratePdfParamsModel generatePdfParamsModel = new GeneratePdfParamsModel();
            generatePdfParamsModel.setSqlx(paramsModel.getSqlx());
            generatePdfParamsModel.setFjlx(string);
            GxYyLcdyPz gxYyLcdyPz = this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
            if (gxYyLcdyPz == null && string.contains(";")) {
                List<String> fjlxList = Arrays.asList(string.split(";"));
                generatePdfParamsModel.setFjlx(fjlxList.get(0));
                gxYyLcdyPz = this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
            }
            if (gxYyLcdyPz == null) {
                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u7f3a\u5c11\u6d41\u7a0b\u6253\u5370\u914d\u7f6e\uff0c\u7533\u8bf7\u7c7b\u578b:" + generatePdfParamsModel.getSqlx() + "\u9644\u4ef6\u7c7b\u578b\uff1a" + generatePdfParamsModel.getFjlx());
            }
            gxYyLcdyPzsList.add(gxYyLcdyPz);
        }
        log.info("gxYyLcdyPzsList:{}", (Object)JSON.toJSONString((Object)gxYyLcdyPzsList));
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        SignFlowsCreateBoardParamsModel signFlowsCreateBoardParamsModel = (SignFlowsCreateBoardParamsModel)paramsModel.getSignBoardList().get(0);
        String qsrQm = ((SignFlowsCreateSignParamsModel)signFlowsCreateBoardParamsModel.getSignList().get(0)).getSignAndFpBase64();
        String qzcsStr = "0";
        try {
            qzcsStr = (String)this.redisRepository.get("qzcs" + paramsModel.getSlbh());
        }
        catch (Exception e) {
            qzcsStr = "1";
            log.info(e.getMessage());
        }
        log.info("qzcsStr:{}", (Object)qzcsStr);
        Integer qzcs = 0;
        if (StringUtils.isNotBlank((CharSequence)qzcsStr)) {
            qzcs = Integer.valueOf(qzcsStr);
        }
        ArrayList fjxxList = Lists.newArrayList();
        Set fjlxSet = gxYyLcdyPzsList.stream().map(GxYyLcdyPz::getFjlx).collect(Collectors.toSet());
        for (String fjlx : fjlxSet) {
            GxYyFjxm gxYyFjxm = this.gxYyFjxmRepository.getBySlbhAndFjlx(paramsModel.getSlbh(), fjlx);
            if (gxYyFjxm == null) continue;
            GxYyLcdyPz gxYyLcdyPz = null;
            for (GxYyLcdyPz gxYyLcdyPzTemp : gxYyLcdyPzsList) {
                if (!StringUtils.equals((CharSequence)gxYyLcdyPzTemp.getFjlx(), (CharSequence)fjlx)) continue;
                gxYyLcdyPz = gxYyLcdyPzTemp;
            }
            log.info("gxYyLcdyPz:{}", (Object)JSON.toJSONString(gxYyLcdyPz));
            List gxYyFjxxList = this.gxYyFjxxRepository.getByFjxmid(gxYyFjxm.getXmid());
            if (!CollectionUtils.isNotEmpty((Collection)gxYyFjxxList)) continue;
            for (GxYyFjxx gxYyFjxx : gxYyFjxxList) {
                File file = new File(uploadPath + File.separator + gxYyFjxx.getFilepath() + File.separator + gxYyFjxx.getFjmc());
                try {
                    byte[] bytes;
                    if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getX()) && StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getY())) {
                        Float x = null;
                        Float y = null;
                        if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getX())) {
                            x = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getX()));
                            if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbX())) {
                                x = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getX()) + Float.parseFloat(gxYyLcdyPz.getSyzbX()) * (float)qzcs.intValue());
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getY())) {
                            y = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getY()));
                            if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbY())) {
                                y = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getY()) + Float.parseFloat(gxYyLcdyPz.getSyzbY()) * (float)qzcs.intValue());
                            }
                        }
                        bytes = PdfSigner.addSignatureToPdf((File)file, (String)qsrQm, (Float)x, (Float)y);
                    } else {
                        bytes = PdfSigner.addSignatureToPdf((File)file, (String)qsrQm, null, null);
                    }
                    SignFlowsCreateFjxxResultModel fjxxResultModel = new SignFlowsCreateFjxxResultModel();
                    fjxxResultModel.setFjid(gxYyFjxx.getFjid());
                    fjxxResultModel.setFjmc(gxYyFjxx.getFjmc());
                    fjxxResultModel.setBase64(FileUtils.byteToBase64((byte[])bytes));
                    fjxxList.add(fjxxResultModel);
                }
                catch (IOException e) {
                    throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u7b7e\u540d\u56fe\u7247\u4e0epdf\u5408\u5e76\u51fa\u73b0\u5f02\u5e38");
                }
            }
        }
        resultModel.setFjxxList((List)fjxxList);
        this.redisRepository.set("qzcs" + paramsModel.getSlbh(), (Object)String.valueOf(qzcs + 1), 600000L);
        return null;
    }
}

