/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event;

import cn.gtmap.hlw.core.domain.sign.SignFlowsCreateEventService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateDataParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.result.SignFlowsCreateDataResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SignFlowsCreateDomainService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowsCreateDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, SignFlowsCreateEventService> eventServiceMap;

    public SignFlowsCreateDataResultModel event(SignFlowsCreateParamsModel paramsModel) {
        SignFlowsCreateDataParamsModel signFlowsCreateDataParamsModel = new SignFlowsCreateDataParamsModel();
        signFlowsCreateDataParamsModel.setFjxxList(new ArrayList());
        signFlowsCreateDataParamsModel.setQsrxxList(new ArrayList());
        paramsModel.setData(signFlowsCreateDataParamsModel);
        paramsModel.setFileList(new ArrayList());
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        log.info("\u4e91\u7b7e\u53d1\u8d77lydzList:{}", (Object)JSON.toJSONString((Object)lysjList));
        SignFlowsCreateDataResultModel resultModel = new SignFlowsCreateDataResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SignFlowsCreateEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            if (eventService == null) continue;
            eventService.doWork(paramsModel, resultModel);
            if (paramsModel.getSfzd() == null || !paramsModel.getSfzd().booleanValue()) continue;
            log.info("\u7531\u4e8e\u9886\u57df\u52a8\u4f5c{}\u901a\u77e5\uff0c\u540e\u7eed\u52a8\u4f5c\u5df2\u7ec8\u6b62\u6267\u884c", (Object)lydz.getLydzsxl());
            break;
        }
        return resultModel;
    }
}

