/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event;

import cn.gtmap.hlw.core.domain.sign.SignFlowsChekcEventService;
import cn.gtmap.hlw.core.domain.sign.model.chekc.params.SignFlowChekcParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.chekc.result.SignFlowChekcResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SignFlowsCheckDomainService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowsCheckDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, SignFlowsChekcEventService> eventServiceMap;

    public SignFlowChekcResultModel event(SignFlowChekcParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SignFlowChekcResultModel resultModel = new SignFlowChekcResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SignFlowsChekcEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            if (eventService == null) continue;
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

