/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign.event;

import cn.gtmap.hlw.core.domain.sign.SignBoardStartEventService;
import cn.gtmap.hlw.core.domain.sign.model.query.params.SignBoardStartParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.query.params.SignBoardStartResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SignBoardStartDomainService {
    private static final Logger log = LoggerFactory.getLogger(SignBoardStartDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, SignBoardStartEventService> eventServiceMap;

    public SignBoardStartResultModel event(SignBoardStartParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SignBoardStartResultModel resultModel = new SignBoardStartResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SignBoardStartEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

