/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sign;

import cn.gtmap.hlw.core.domain.sign.SignFlowCommonService;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateFjxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxParamsModel;
import cn.gtmap.hlw.core.domain.sign.model.create.params.SignFlowsCreateQsrxxQswjQsxxParamsModel;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyLcdyPz;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYySqxxKz;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyLcdyPzRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxKzRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignFlowCommonServiceImpl
implements SignFlowCommonService {
    private static final Logger log = LoggerFactory.getLogger(SignFlowCommonServiceImpl.class);
    @Resource
    private GxYyLcdyPzRepository gxYyLcdyPzRepository;
    @Resource
    private GxYyFjxmRepository gxYyFjxmRepository;
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private RedisRepository redisRepository;
    @Resource
    private GxYySqxxKzRepository gxYySqxxKzRepository;
    @Resource
    private GxYyQlrRepository gxYyQlrRepository;

    public Boolean isExistsYqFjlx(List<SignFlowsCreateFjxxParamsModel> fjxxList, String fjlx) {
        if (CollectionUtils.isNotEmpty(fjxxList)) {
            for (SignFlowsCreateFjxxParamsModel signFlowsCreateFjxxParamsModel : fjxxList) {
                if (!fjlx.equals(signFlowsCreateFjxxParamsModel.getFjlx())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSkipSignFlow(List<GxYySqxx> sqxxList) {
        boolean isSkipSignFlow = false;
        GxYySqxxKz gxYySqxxKz = this.gxYySqxxKzRepository.get(sqxxList.get(0).getSqid());
        if (gxYySqxxKz != null && Status2Enum.NO.getCode().equals(gxYySqxxKz.getSfyq())) {
            return true;
        }
        List gxYyQlrList = this.gxYyQlrRepository.getBySlbh(sqxxList.get(0).getSlbh());
        int sYqNum = 0;
        int fYqNum = 0;
        for (GxYyQlr gxYyQlr : gxYyQlrList) {
            if (Status2Enum.YES.getCode().equals(gxYyQlr.getSfyq())) {
                ++sYqNum;
                continue;
            }
            if (!Status2Enum.NO.getCode().equals(gxYyQlr.getSfyq())) continue;
            ++fYqNum;
        }
        if (sYqNum == 0 && fYqNum > 0) {
            return true;
        }
        return isSkipSignFlow;
    }

    public List<SignFlowsCreateQsrxxParamsModel> getSfxzzrQsrxxList(List<SignFlowsCreateQsrxxParamsModel> qsrxxList) {
        log.info("qsrxxList\uff1a{}", (Object)JSON.toJSONString(qsrxxList));
        if (CollectionUtils.isEmpty(qsrxxList)) {
            return qsrxxList;
        }
        ArrayList newQsrxxList = Lists.newArrayList();
        HashSet<String> qlrzjhSet = new HashSet<String>();
        HashSet<String> duplicateZjhSet = new HashSet<String>();
        for (SignFlowsCreateQsrxxParamsModel qsrxxParamsModel : qsrxxList) {
            if (!StringUtils.endsWithAny((CharSequence)qsrxxParamsModel.getQlrlx(), (CharSequence[])new CharSequence[]{QlrTypeEnum.QLRLX_QLR.getCode(), QlrTypeEnum.QLRLX_YWR.getCode()}) || qlrzjhSet.add(qsrxxParamsModel.getZjh())) continue;
            duplicateZjhSet.add(qsrxxParamsModel.getZjh());
        }
        for (SignFlowsCreateQsrxxParamsModel qsrxxParamsModel : qsrxxList) {
            if (duplicateZjhSet.contains(qsrxxParamsModel.getZjh()) && QlrTypeEnum.QLRLX_QLR.getCode().equals(qsrxxParamsModel.getQlrlx())) continue;
            newQsrxxList.add(qsrxxParamsModel);
        }
        log.info("newQsrxxList\uff1a{}", (Object)JSON.toJSONString((Object)newQsrxxList));
        return newQsrxxList;
    }

    public SignFlowsCreateQsrxxQswjQsxxParamsModel setPosXy(SignFlowsCreateQsrxxQswjQsxxParamsModel qsxx, GxYyLcdyPz gxYyLcdyPz, Integer index) {
        Float posY;
        Float posX;
        qsxx.setPosX("0");
        qsxx.setPosY("0");
        if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getX())) {
            qsxx.setPosX(gxYyLcdyPz.getX());
            if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbX())) {
                posX = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getX()) + Float.parseFloat(gxYyLcdyPz.getSyzbX()) * (float)index.intValue());
                qsxx.setPosX(String.format("%.0f", posX));
            }
        } else if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbX())) {
            posX = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getSyzbX()) * (float)index.intValue());
            qsxx.setPosX(String.valueOf(String.format("%.0f", posX)));
        }
        if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getY())) {
            qsxx.setPosY(gxYyLcdyPz.getY());
            if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbY())) {
                posY = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getY()) + Float.parseFloat(gxYyLcdyPz.getSyzbY()) * (float)index.intValue());
                qsxx.setPosY(String.valueOf(String.format("%.0f", posY)));
            }
        } else if (StringUtils.isNotBlank((CharSequence)gxYyLcdyPz.getSyzbY())) {
            posY = Float.valueOf(Float.parseFloat(gxYyLcdyPz.getSyzbY()) * (float)index.intValue());
            qsxx.setPosY(String.format("%.0f", posY));
        }
        return qsxx;
    }

    public GxYyLcdyPz getGxYyLcdyPz(SignFlowsCreateParamsModel paramsModel, String djyy, String fjlx, String qlrlx) {
        GeneratePdfParamsModel generatePdfParamsModel = new GeneratePdfParamsModel();
        generatePdfParamsModel.setSqlx(paramsModel.getSqlx());
        generatePdfParamsModel.setFjlx(fjlx);
        generatePdfParamsModel.setQydm(paramsModel.getQydm());
        generatePdfParamsModel.setDjyy(djyy);
        generatePdfParamsModel.setQlrlx(qlrlx);
        return this.gxYyLcdyPzRepository.getByParams(generatePdfParamsModel);
    }

    public SignFlowsCreateFjxxParamsModel getSignFlowsCreateFjxxParamsModel(SignFlowsCreateParamsModel paramsModel, String fjlx) {
        List gxYyFjxxList;
        SignFlowsCreateFjxxParamsModel fjxx = new SignFlowsCreateFjxxParamsModel();
        GxYyFjxm gxYyFjxm = this.gxYyFjxmRepository.getBySlbhAndFjlx(paramsModel.getSlbh(), fjlx);
        if (gxYyFjxm != null && CollectionUtils.isNotEmpty((Collection)(gxYyFjxxList = this.gxYyFjxxRepository.getByFjxmid(gxYyFjxm.getXmid())))) {
            GxYyFjxx gxYyFjxx = null;
            if (StringUtils.isNotBlank((CharSequence)paramsModel.getSignFjmc())) {
                for (GxYyFjxx gxYyFjxxTemp : gxYyFjxxList) {
                    if (!paramsModel.getSignFjmc().equals(gxYyFjxxTemp.getFjmc())) continue;
                    gxYyFjxx = gxYyFjxxTemp;
                    break;
                }
            } else {
                gxYyFjxx = (GxYyFjxx)gxYyFjxxList.get(0);
            }
            if (gxYyFjxx != null) {
                fjxx.setSqid(gxYyFjxx.getSqid());
                fjxx.setFjid(gxYyFjxx.getFjid());
                fjxx.setFjmc(gxYyFjxx.getFjmc());
                fjxx.setFjlx(fjlx);
                fjxx.setQssx("1");
                String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
                fjxx.setFjxzdz(uploadPath + File.separator + gxYyFjxx.getFilepath() + File.separator + fjxx.getFjmc());
            }
        }
        return fjxx;
    }
}

