/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sfxx.event.save;

import cn.gtmap.hlw.core.domain.sfxx.SaveSfxxEventService;
import cn.gtmap.hlw.core.domain.sfxx.model.save.SaveSfxxParamsModel;
import cn.gtmap.hlw.core.domain.sfxx.model.save.SaveSfxxResultModel;
import cn.gtmap.hlw.core.domain.sfxx.model.save.SaveSfxxSfxmParamsModel;
import cn.gtmap.hlw.core.enums.dict.JfztEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdJfxm;
import cn.gtmap.hlw.core.model.WctJySfssxx;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdJfxmRepository;
import cn.gtmap.hlw.core.repository.WctJySfssxxRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaveWctSfssxxEvent
implements SaveSfxxEventService {
    @Autowired
    private WctJySfssxxRepository wctJySfssxxRepository;
    @Autowired
    private GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    private GxYyZdJfxmRepository gxYyZdJfxmRepository;

    public void doWork(SaveSfxxParamsModel paramsModel, SaveSfxxResultModel resultModel) {
        String qlrlb = QlrTypeEnum.QLRLX_QLR.getCode();
        if (CollectionUtils.isNotEmpty((Collection)paramsModel.getSfxmList())) {
            qlrlb = ((SaveSfxxSfxmParamsModel)paramsModel.getSfxmList().get(0)).getQlrlb();
        }
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("nwslbh", paramsModel.getSlbh());
        paramMap.put("qlrlb", qlrlb);
        List sfssxxList = this.wctJySfssxxRepository.getListByMap((Map)paramMap);
        if (CollectionUtils.isEmpty((Collection)sfssxxList)) {
            GxYySqxx gxYySqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
            if (gxYySqxx != null) {
                List jfxmList = this.gxYyZdJfxmRepository.listByQydm(gxYySqxx.getQydm());
                if (CollectionUtils.isEmpty((Collection)jfxmList)) {
                    throw new BizException(ErrorEnum.NOT_FOUND.getCode(), "\u672a\u67e5\u8be2\u5230\u7f34\u8d39\u9879\u76ee\u914d\u7f6e\u4fe1\u606f");
                }
                GxYyZdJfxm yyZdJfxm = (GxYyZdJfxm)jfxmList.get(0);
                String sfssxxid = StringUtil.hex32();
                WctJySfssxx wctJySfssxx = WctJySfssxx.builder().sfssxxid(sfssxxid).xmid(sfssxxid).qlrlb(QlrTypeEnum.QLRLX_QLR.getCode()).nwslbh(paramsModel.getSlbh()).qxdm(gxYySqxx.getQydm()).jfzt(JfztEnum.JFZT_WJF.getCode()).sfyj(Status2Enum.NO.getCode()).zsdwdm(yyZdJfxm.getZsdwdm()).zsdwmc(yyZdJfxm.getZsdwmc()).build();
                this.wctJySfssxxRepository.save(wctJySfssxx);
                paramsModel.setSfssxxid(sfssxxid);
            }
        } else {
            paramsModel.setSfssxxid(((WctJySfssxx)sfssxxList.get(0)).getSfssxxid());
        }
    }
}

