/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.sfxx.event;

import cn.gtmap.hlw.core.domain.sfxx.SaveSfxxEventService;
import cn.gtmap.hlw.core.domain.sfxx.model.save.SaveSfxxParamsModel;
import cn.gtmap.hlw.core.domain.sfxx.model.save.SaveSfxxResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaveSfxxDomainService {
    private static final Logger log = LoggerFactory.getLogger(SaveSfxxDomainService.class);
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, SaveSfxxEventService> eventServiceMap;

    public SaveSfxxResultModel event(SaveSfxxParamsModel paramsModel) {
        log.info("SaveSfxxDomainService.paramsModel:" + JSONObject.toJSONString((Object)paramsModel));
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        log.info("SaveSfxxDomainService.lysjList:" + JSONObject.toJSONString((Object)lysjList));
        SaveSfxxResultModel resultModel = new SaveSfxxResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SaveSfxxEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

