/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.service;

import cn.gtmap.hlw.core.domain.jdxx.JdxxDomainEventService;
import cn.gtmap.hlw.core.domain.jdxx.jdxx.JdxxDomainParamsModel;
import cn.gtmap.hlw.core.domain.jdxx.jdxx.JdxxDomainResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JdxxDomainService {
    @Autowired
    GxYySqlxJdxxLysjRelRepository jdxxLysjRelRepository;
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Autowired
    private Map<String, JdxxDomainEventService> eventServiceMap;

    public JdxxDomainResultModel event(JdxxDomainParamsModel paramsModel) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{paramsModel.getJddm(), paramsModel.getSqlx()})) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List lysjList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getLysjdm())) {
            lysjList = this.jdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx());
        } else {
            lysjList.add(this.jdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm()));
        }
        if (CollectionUtils.isEmpty((Collection)lysjList)) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        for (JdxxLysjModel lysjModel : lysjList) {
            if (!CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) continue;
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        List sqxxList = this.sqxxRepository.list(paramsModel.getSlbh());
        paramsModel.setSqxxList(sqxxList);
        JdxxDomainResultModel resultModel = new JdxxDomainResultModel();
        for (JdxxLysjModel lysjModel : lysjList) {
            try {
                for (GxYyLydz lydz : lysjModel.getLydzList()) {
                    JdxxDomainEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                    eventService.doWork(paramsModel, resultModel);
                }
            }
            catch (BizException b) {
                throw b;
            }
            catch (Exception e) {
                throw new BizException(ApplyCodeEnum.APPLY_LCDY_ZXYC.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
            }
        }
        return resultModel;
    }
}

