/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.notice.event.yzm;

import cn.gtmap.hlw.core.domain.notice.SmsYzmEventService;
import cn.gtmap.hlw.core.domain.notice.model.SmsYzmParamsModel;
import cn.gtmap.hlw.core.dto.notice.sms.SmsSendManageResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.encryption.md5.Md5;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.user.enums.UserErrorEnum;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SmsYzmCheckUserMustExistEvent
implements SmsYzmEventService {
    @Resource
    Environment environment;
    @Resource
    private GxYyUserRepository gxYyUserRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    RedisRepository redisRepository;

    public void doWork(SmsYzmParamsModel paramsModel, SmsSendManageResultDTO sendManageResultDTO) {
        String key = StringUtil.toString((Object)this.redisRepository.get("md5.salt"));
        if (StringUtils.isBlank((CharSequence)key)) {
            key = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("md5.salt");
        }
        String md5PassWord = Md5.sign((String)Sm2lib.decode((String)paramsModel.getLoginPwd()), (String)key, (String)String.valueOf(StandardCharsets.UTF_8));
        List gxYyUserList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getLoginPwd()) && StringUtils.isNotBlank((CharSequence)paramsModel.getLxdh())) {
            gxYyUserList = this.gxYyUserRepository.getUserByPwdAndLxdh(md5PassWord, paramsModel.getLxdh());
            if (CollectionUtils.isEmpty((Collection)gxYyUserList)) {
                throw new BizException(UserErrorEnum.USER_NOT_EXISTS.getCode(), "\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
            }
        } else {
            gxYyUserList = this.gxYyUserRepository.getByLxdh(paramsModel.getLxdh());
            if (CollectionUtils.isEmpty((Collection)gxYyUserList)) {
                throw new BizException(UserErrorEnum.USER_NOT_EXISTS.getCode(), UserErrorEnum.USER_NOT_EXISTS.getMsg());
            }
        }
    }
}

