/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.notice.event;

import cn.gtmap.hlw.core.domain.notice.SmsYzmEventService;
import cn.gtmap.hlw.core.domain.notice.model.SmsYzmParamsModel;
import cn.gtmap.hlw.core.dto.notice.sms.SmsSendManageResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsYzmDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, SmsYzmEventService> eventServiceMap;

    public SmsSendManageResultDTO event(SmsYzmParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        SmsSendManageResultDTO sendManageResultDTO = new SmsSendManageResultDTO();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            SmsYzmEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, sendManageResultDTO);
        }
        return sendManageResultDTO;
    }
}

