/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.mz.jtcy.event;

import cn.gtmap.hlw.core.domain.mz.JtcyQueryEventService;
import cn.gtmap.hlw.core.domain.mz.model.JtcyQueryParamsModel;
import cn.gtmap.hlw.core.domain.mz.model.JtcyQueryResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JtcyQueryDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, JtcyQueryEventService> eventServiceMap;
    @Resource
    private HlwPzPzxRepository hlwPzPzxRepository;

    public JtcyQueryResultModel event(JtcyQueryParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        String qydm = StringUtils.isNotBlank((CharSequence)paramsModel.getQydm()) ? paramsModel.getQydm() : this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("register.dwdm");
        paramsModel.setQydm(qydm);
        JtcyQueryResultModel resultModel = new JtcyQueryResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            JtcyQueryEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

