/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.lzsq.event;

import cn.gtmap.hlw.core.domain.lzsq.CommonInitEventService;
import cn.gtmap.hlw.core.domain.lzsq.model.CommonInitParamModel;
import cn.gtmap.hlw.core.dto.lzsq.CommonSqxxInitResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CommonInitDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, CommonInitEventService> eventServiceMap;

    public CommonSqxxInitResultDTO event(CommonInitParamModel paramModel) {
        if (StringUtils.isBlank((CharSequence)paramModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramModel.getLysjdm(), paramModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        CommonSqxxInitResultDTO commonSqxxInitResultDTO = new CommonSqxxInitResultDTO();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            CommonInitEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramModel, commonSqxxInitResultDTO);
        }
        return commonSqxxInitResultDTO;
    }
}

