/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.lzsq.event;

import cn.gtmap.hlw.core.domain.lzsq.CommonApplyEventService;
import cn.gtmap.hlw.core.domain.lzsq.model.CommonApplyParamModel;
import cn.gtmap.hlw.core.dto.lzsq.CommonApplyResultDTO;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CommonApplyDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, CommonApplyEventService> eventServiceMap;

    public CommonApplyResultDTO event(CommonApplyParamModel paramModel) {
        if (StringUtils.isBlank((CharSequence)paramModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramModel.getLysjdm(), paramModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        CommonApplyResultDTO commonApplyResultDTO = new CommonApplyResultDTO();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            CommonApplyEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramModel, commonApplyResultDTO);
        }
        return commonApplyResultDTO;
    }
}

