/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.login.event;

import cn.gtmap.hlw.core.domain.login.LoginEventService;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LoginParamsModel;
import cn.gtmap.hlw.core.model.LoginResultModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, LoginEventService> eventServiceMap;

    public LoginResultModel login(@NotNull LoginParamsModel loginParamsModel) {
        if (StringUtils.isBlank((CharSequence)loginParamsModel.getLysjdm())) {
            throw new BizException(LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getCode(), LoginStatusEnum.LOGIN_LYSJDM_NOTNULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(loginParamsModel.getLysjdm(), null);
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getCode(), LoginStatusEnum.LOGIN_QUERY_LYSJ_NULL.getMsg());
        }
        LoginResultModel resultModel = new LoginResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            LoginEventService loginEventService = this.eventServiceMap.get(lydz.getLydzsxl());
            loginEventService.doWork(loginParamsModel, resultModel);
        }
        return resultModel;
    }
}

