/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.login.event;

import cn.gtmap.hlw.core.domain.login.LoginEventService;
import cn.gtmap.hlw.core.enums.dict.RoleEnum;
import cn.gtmap.hlw.core.enums.status.StatusEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyBelongRoleRel;
import cn.gtmap.hlw.core.model.GxYyRole;
import cn.gtmap.hlw.core.model.GxYyUser;
import cn.gtmap.hlw.core.model.GxYyUserRoleRel;
import cn.gtmap.hlw.core.model.LoginParamsModel;
import cn.gtmap.hlw.core.model.LoginResultModel;
import cn.gtmap.hlw.core.repository.GxYyBelongRoleRelRepository;
import cn.gtmap.hlw.core.repository.GxYyOrgRepository;
import cn.gtmap.hlw.core.repository.GxYyRoleRepository;
import cn.gtmap.hlw.core.repository.GxYyUserOrgRelRepository;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.core.repository.GxYyUserRoleRelRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.encryption.md5.Md5;
import cn.gtmap.hlw.core.util.encryption.sm2.Sm2lib;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import cn.gtmap.hlw.domain.login.enums.LoginTypeEnum;
import cn.hutool.core.collection.CollUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class LoginCheckUserEnent
implements LoginEventService {
    @Autowired
    GxYyUserRepository gxYyUserRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    GxYyUserOrgRelRepository gxYyUserOrgRelRepository;
    @Autowired
    GxYyOrgRepository gxYyOrgRepository;
    @Autowired
    GxYyUserRoleRelRepository gxYyUserRoleRelRepository;
    @Autowired
    GxYyRoleRepository gxYyRoleRepository;
    @Autowired
    GxYyBelongRoleRelRepository gxYyBelongRoleRelRepository;
    @Autowired
    RedisRepository redisRepository;

    public void doWork(LoginParamsModel loginParamsModel, LoginResultModel resultModel) {
        GxYyRole gxYyRole;
        GxYyUser gxYyUser = loginParamsModel.getGxYyUser();
        if (gxYyUser == null) {
            throw new BizException(LoginStatusEnum.PASSWORD_FAIL.getCode(), LoginStatusEnum.PASSWORD_FAIL.getMsg());
        }
        if (StatusEnum.TRUE.getCode().equals(String.valueOf(gxYyUser.getIsValid()))) {
            throw new BizException(LoginStatusEnum.JY_FAIL.getCode(), gxYyUser.getValidReason());
        }
        String pzxValue = "";
        if (LoginTypeEnum.LOGIN_TYPE_PERSON.getMsg().equals(loginParamsModel.getLoginType())) {
            pzxValue = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("login.person.dlfs");
        } else if (LoginTypeEnum.LOGIN_TYPE_ORGANIZE.getMsg().equals(loginParamsModel.getLoginType())) {
            pzxValue = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("login.organize.dlfs");
        } else if (LoginTypeEnum.LOGIN_TYPE_INTERFACE.getMsg().equals(loginParamsModel.getLoginType())) {
            pzxValue = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("login.interface.dlfs");
        } else if (LoginTypeEnum.LOGIN_TYPE_DJJG.getMsg().equals(loginParamsModel.getLoginType())) {
            pzxValue = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("login.djjg.dlfs");
        }
        String unlockTime = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("passworderror.count.unlocktime");
        Integer unlockTimeValue = Integer.valueOf(StringUtils.isBlank((CharSequence)unlockTime) ? "30" : unlockTime);
        if (!StringUtils.equalsAny((CharSequence)pzxValue, (CharSequence[])new CharSequence[]{LoginTypeEnum.LOGIN_YZM_TYPE.getCode(), LoginTypeEnum.LOGIN_YZMMM_TYPE.getCode()})) {
            String md5PassWord;
            String key = StringUtil.toString((Object)this.redisRepository.get("md5.salt"));
            if (StringUtils.isBlank((CharSequence)key)) {
                key = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("md5.salt");
            }
            if (!(md5PassWord = Md5.sign((String)Sm2lib.decode((String)loginParamsModel.getLoginPwd()), (String)key, (String)String.valueOf(StandardCharsets.UTF_8))).equals(gxYyUser.getUserPwd())) {
                String redisKey = "passworderror_count:${userGuid}".replaceAll("\\$\\{userGuid\\}", gxYyUser.getUserGuid());
                Integer redisErrorCount = (Integer)this.redisRepository.get(redisKey);
                if (redisErrorCount == null) {
                    this.redisRepository.set(redisKey, (Object)1, (long)(unlockTimeValue * 60));
                } else {
                    this.redisRepository.set(redisKey, (Object)(redisErrorCount + 1), (long)(unlockTimeValue * 60));
                }
                throw new BizException(LoginStatusEnum.PASSWORD_FAIL.getCode(), LoginStatusEnum.PASSWORD_FAIL.getMsg());
            }
        } else {
            String redisValue = (String)this.redisRepository.get("smsYzmLxdh:" + loginParamsModel.getLoginName());
            if (StringUtils.isEmpty((CharSequence)loginParamsModel.getYzm())) {
                throw new BizException(LoginStatusEnum.YZM_NULL.getCode(), LoginStatusEnum.YZM_NULL.getMsg());
            }
            if (StringUtils.isEmpty((CharSequence)redisValue)) {
                throw new BizException(LoginStatusEnum.YZM_FALSE.getCode(), LoginStatusEnum.YZM_FALSE.getMsg());
            }
            if (!StringUtils.equals((CharSequence)redisValue, (CharSequence)loginParamsModel.getYzm())) {
                throw new BizException(LoginStatusEnum.YZM_FAIL.getCode(), LoginStatusEnum.YZM_FAIL.getMsg());
            }
            this.redisRepository.del(new String[]{"smsYzmLxdh:" + loginParamsModel.getLoginName()});
        }
        resultModel.setUserGuid(gxYyUser.getUserGuid());
        resultModel.setIszwlogin(gxYyUser.getIszwlogin());
        resultModel.setLxDh(gxYyUser.getLxDh());
        resultModel.setIsCalogin(gxYyUser.getIsCalogin());
        resultModel.setLxDhTm(gxYyUser.getLxDhTm());
        resultModel.setZjType(gxYyUser.getZjType());
        resultModel.setUserZjidTm(gxYyUser.getUserZjidTm());
        resultModel.setUserName(gxYyUser.getUserName());
        resultModel.setSfyz(gxYyUser.getSfyz());
        resultModel.setRealName(gxYyUser.getRealName());
        resultModel.setQydm(gxYyUser.getQydm());
        resultModel.setRealNameTm(gxYyUser.getRealNameTm());
        resultModel.setUserZjid(gxYyUser.getUserZjid());
        resultModel.setCyzzzh(gxYyUser.getZgzhbh());
        resultModel.setIsCalogin(gxYyUser.getIsCalogin());
        resultModel.setSfyqzqx(gxYyUser.getSfyqzqx());
        resultModel.setSysIp(gxYyUser.getSysIp());
        resultModel.setNwwbs(gxYyUser.getNwwbs());
        List userRoleRelList = this.gxYyUserRoleRelRepository.getGxYyUserRoleRelsByUserId(gxYyUser.getUserGuid());
        if (userRoleRelList == null || CollectionUtils.isEmpty((Collection)userRoleRelList)) {
            throw new BizException(LoginStatusEnum.NO_ROLE.getCode(), LoginStatusEnum.NO_ROLE.getMsg());
        }
        List roleIdList = userRoleRelList.stream().map(GxYyUserRoleRel::getRoleId).collect(Collectors.toList());
        List roleList = this.gxYyRoleRepository.getRoleList(roleIdList);
        if (LoginTypeEnum.LOGIN_TYPE_PERSON.getMsg().equals(loginParamsModel.getLoginType())) {
            resultModel.setRoleId("2");
            gxYyRole = this.gxYyRoleRepository.get("2");
            resultModel.setRoleName(gxYyRole == null ? "" : gxYyRole.getRoleName());
        } else if (LoginTypeEnum.LOGIN_TYPE_INTERFACE.getMsg().equals(loginParamsModel.getLoginType())) {
            gxYyRole = null;
            gxYyRole = roleList.size() == 1 ? (GxYyRole)roleList.get(0) : (GxYyRole)CollUtil.findOne((Iterable)roleList, item -> !StringUtils.equals((CharSequence)item.getRoleId(), (CharSequence)RoleEnum.BDGL_ROLE_GR.getCode()));
            resultModel.setRoleId(gxYyRole.getRoleId());
            resultModel.setRoleName(gxYyRole.getRoleName());
        } else {
            if (roleList.size() == 1 && "2".equals(((GxYyRole)roleList.get(0)).getRoleId())) {
                throw new BizException(LoginStatusEnum.NO_LOGIN.getCode(), LoginStatusEnum.NO_LOGIN.getMsg());
            }
            gxYyRole = "2".equals(((GxYyRole)roleList.get(0)).getRoleId()) ? (GxYyRole)roleList.get(1) : (GxYyRole)roleList.get(0);
            resultModel.setRoleId(gxYyRole.getRoleId());
            resultModel.setRoleName(gxYyRole.getRoleName());
        }
        GxYyBelongRoleRel gxYyBelongRoleRel = this.gxYyBelongRoleRelRepository.getBelongRoleRelByRoleId(resultModel.getRoleId());
        if (gxYyBelongRoleRel != null) {
            resultModel.setYhzxdz(gxYyBelongRoleRel.getYhzxdz());
        }
    }
}

