/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.login.event;

import cn.gtmap.hlw.core.domain.login.LoginEventService;
import cn.gtmap.hlw.core.enums.dict.GllxEnum;
import cn.gtmap.hlw.core.enums.status.Status2Enum;
import cn.gtmap.hlw.core.enums.status.StatusEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyOrg;
import cn.gtmap.hlw.core.model.GxYyOrgCaRel;
import cn.gtmap.hlw.core.model.GxYyUser;
import cn.gtmap.hlw.core.model.GxYyUserOrgRel;
import cn.gtmap.hlw.core.model.LoginParamsModel;
import cn.gtmap.hlw.core.model.LoginResultModel;
import cn.gtmap.hlw.core.repository.GxYyOrgCaRelRepository;
import cn.gtmap.hlw.core.repository.GxYyOrgRepository;
import cn.gtmap.hlw.core.repository.GxYyUserOrgRelRepository;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.domain.login.enums.LoginStatusEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginCheckOrgEnent
implements LoginEventService {
    @Autowired
    GxYyUserRepository gxYyUserRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    GxYyUserOrgRelRepository gxYyUserOrgRelRepository;
    @Autowired
    GxYyOrgRepository gxYyOrgRepository;
    @Autowired
    GxYyOrgCaRelRepository gxYyOrgCaRelRepository;

    public void doWork(LoginParamsModel loginParamsModel, LoginResultModel resultModel) {
        GxYyUser gxYyUser = loginParamsModel.getGxYyUser();
        if (gxYyUser == null || StringUtils.isBlank((CharSequence)gxYyUser.getUserGuid())) {
            throw new BizException(LoginStatusEnum.NO_USER.getCode(), LoginStatusEnum.NO_USER.getMsg());
        }
        GxYyUserOrgRel gxYyUserOrgRel = this.gxYyUserOrgRelRepository.getUserOrgRelByUserId(gxYyUser.getUserGuid());
        GxYyOrg gxYyOrg = this.gxYyOrgRepository.get(gxYyUserOrgRel.getOrgId());
        if (gxYyOrg == null) {
            throw new BizException(LoginStatusEnum.NO_USER.getCode(), LoginStatusEnum.NO_USER.getMsg());
        }
        resultModel.setOrgName(gxYyOrg.getOrgName());
        resultModel.setOrgFddbrdh(gxYyOrg.getOrgFddbrdh());
        resultModel.setOrgFddbr(gxYyOrg.getOrgFddbr());
        resultModel.setOrgId(gxYyOrg.getOrgId());
        resultModel.setOrgFddbrTm(gxYyOrg.getOrgFddbrTm());
        resultModel.setOrgFddbrzjh(gxYyOrg.getOrgFddbrzjh());
        resultModel.setOrgFddbrdhTm(gxYyOrg.getOrgFddbrdhTm());
        resultModel.setOrgLxdh(gxYyOrg.getOrgLxdh());
        resultModel.setOrgQydm(StringUtils.isNotBlank((CharSequence)gxYyOrg.getQydm()) ? gxYyOrg.getQydm() : gxYyOrg.getOrgXzqdm());
        resultModel.setOrgFddbrzjhTm(gxYyOrg.getOrgFddbrzjhTm());
        resultModel.setOrgTyxydm(gxYyOrg.getOrgTyxydm());
        resultModel.setOrgTyxydmTm(gxYyOrg.getOrgTyxydmTm());
        resultModel.setOrgZjlx(gxYyOrg.getOrgZjlx());
        resultModel.setOrgFddbrzjlx(gxYyOrg.getOrgFddbrzjlx());
        resultModel.setSfyj(gxYyOrg.getSfyj());
        resultModel.setOrgSzsheng(gxYyOrg.getOrgSzsheng());
        resultModel.setOrgSzshi(gxYyOrg.getOrgSzshi());
        resultModel.setOrgSzxian(gxYyOrg.getOrgSzxian());
        if (StatusEnum.TRUE.getCode().equals(resultModel.getIsCalogin())) {
            if (StringUtils.isBlank((CharSequence)loginParamsModel.getCa())) {
                throw new BizException(LoginStatusEnum.ZS_NULL.getCode(), LoginStatusEnum.ZS_NULL.getMsg());
            }
            GxYyOrgCaRel gxYyOrgCaRel = this.gxYyOrgCaRelRepository.getByCa(loginParamsModel.getCa());
            if (gxYyOrgCaRel == null) {
                throw new BizException(LoginStatusEnum.ZS_NO_LOGIN.getCode(), LoginStatusEnum.ZS_NO_LOGIN.getMsg());
            }
            if (StringUtils.equals((CharSequence)gxYyOrgCaRel.getType(), (CharSequence)GllxEnum.GR.getCode()) ? !StringUtils.equals((CharSequence)gxYyOrgCaRel.getOrgId(), (CharSequence)gxYyUser.getUserGuid()) : StringUtils.equals((CharSequence)gxYyOrgCaRel.getType(), (CharSequence)GllxEnum.BM.getCode()) && !StringUtils.equals((CharSequence)gxYyOrgCaRel.getOrgId(), (CharSequence)gxYyOrg.getOrgId())) {
                throw new BizException(LoginStatusEnum.ZS_NO_LOGIN.getCode(), LoginStatusEnum.ZS_NO_LOGIN.getMsg());
            }
        }
        if (!Status2Enum.YES.getCode().equals(resultModel.getIszwlogin())) {
            // empty if block
        }
    }
}

