/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.jyxx.tsjy.event;

import cn.gtmap.hlw.core.domain.jyxx.tsjy.JyxxTsjyEventService;
import cn.gtmap.hlw.core.domain.jyxx.tsjy.model.TsjyQueryParamsModel;
import cn.gtmap.hlw.core.domain.jyxx.tsjy.model.TsjyQueryResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class JyxxTsjyDomainService {
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, JyxxTsjyEventService> eventServiceMap;

    public TsjyQueryResultModel event(TsjyQueryParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        TsjyQueryResultModel resultModel = new TsjyQueryResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            JyxxTsjyEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

