/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.jyxx.hthq.event;

import cn.gtmap.hlw.core.domain.jyxx.hthq.JyxxHtHqxxEventService;
import cn.gtmap.hlw.core.domain.jyxx.hthq.model.HqHtxxParamsModel;
import cn.gtmap.hlw.core.domain.jyxx.hthq.model.JyxxHtxxHqResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JyxxHtxxHqDomainService {
    private static final Logger log = LoggerFactory.getLogger(JyxxHtxxHqDomainService.class);
    @Resource
    private GxYyLysjRepository lysjRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private Map<String, JyxxHtHqxxEventService> eventServiceMap;

    public JyxxHtxxHqResultModel event(HqHtxxParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List gxYySqxxList = this.gxYySqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)gxYySqxxList)) {
            throw new BizException(ApplyCodeEnum.APPLY_SQXX_NULL.getCode(), ApplyCodeEnum.APPLY_SQXX_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getJddm(), paramsModel.getAnid(), ((GxYySqxx)gxYySqxxList.get(0)).getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        JyxxHtxxHqResultModel resultModel = new JyxxHtxxHqResultModel();
        log.info("lysjList.getLydzList():{}", (Object)JSON.toJSONString((Object)lysjList.getLydzList()));
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            JyxxHtHqxxEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

