/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.jyxx.basq.event;

import cn.gtmap.hlw.core.domain.jyxx.basq.JyBaztQueryEventService;
import cn.gtmap.hlw.core.domain.jyxx.basq.model.JyBaztQueryResultModel;
import cn.gtmap.hlw.core.domain.jyxx.basq.model.TsjyBasqModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JyBaztQueryDomainService {
    private static final Logger log = LoggerFactory.getLogger(JyBaztQueryDomainService.class);
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, JyBaztQueryEventService> eventServiceMap;

    public JyBaztQueryResultModel event(TsjyBasqModel paramsModel) {
        JyBaztQueryResultModel resultModel = new JyBaztQueryResultModel();
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List gxYySqxxList = this.gxYySqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)gxYySqxxList)) {
            throw new BizException(ApplyCodeEnum.APPLY_SQXX_NULL.getCode(), ApplyCodeEnum.APPLY_SQXX_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getJddm(), paramsModel.getAnid(), ((GxYySqxx)gxYySqxxList.get(0)).getSqlx());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        log.info("lysjList.getLydzList():{}", (Object)JSON.toJSONString((Object)lysjList.getLydzList()));
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            JyBaztQueryEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

