/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.htxx;

import cn.gtmap.hlw.core.domain.htxx.HtxxThirdEventService;
import cn.gtmap.hlw.core.domain.htxx.model.HtxxThirdParamModel;
import cn.gtmap.hlw.core.domain.htxx.model.HtxxThirdResultModel;
import cn.gtmap.hlw.core.enums.sqlx.JyhtlxEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HtxxThirdDomainService {
    private static final Logger log = LoggerFactory.getLogger(HtxxThirdDomainService.class);
    @Resource
    GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, HtxxThirdEventService> eventServiceMap;

    public HtxxThirdResultModel event(HtxxThirdParamModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        HtxxThirdResultModel resultModel = new HtxxThirdResultModel();
        log.info("\u7b2c\u4e09\u65b9\u5408\u540c\u4fe1\u606f\u67e5\u8be2lysjList:{}", (Object)JSON.toJSONString((Object)lysjList));
        String htType = "";
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getHtType()) && StringUtils.isNotBlank((CharSequence)JyhtlxEnum.getJksxl((String)paramsModel.getHtType()))) {
            htType = paramsModel.getHtType();
        }
        log.info("\u7b2c\u4e09\u65b9\u5408\u540c\u4fe1\u606f\u67e5\u8be2 htType:{}", (Object)htType);
        if (StringUtils.isNotBlank((CharSequence)htType)) {
            HtxxThirdEventService eventService = this.eventServiceMap.get(JyhtlxEnum.getJksxl((String)htType));
            eventService.doWork(paramsModel, resultModel);
        } else {
            for (GxYyLydz lydz : lysjList.getLydzList()) {
                HtxxThirdEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(paramsModel, resultModel);
            }
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{resultModel.getMmhth(), resultModel.getJybh()})) {
            return null;
        }
        return resultModel;
    }
}

