/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.htxx;

import cn.gtmap.hlw.core.domain.htxx.HtxxPlThirdEventService;
import cn.gtmap.hlw.core.domain.htxx.model.HtxxThirdParamModel;
import cn.gtmap.hlw.core.domain.htxx.model.HtxxThirdResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HtxxPlThirdDomainService {
    private static final Logger log = LoggerFactory.getLogger(HtxxPlThirdDomainService.class);
    @Resource
    GxYyLysjRepository lysjRepository;
    @Resource
    private Map<String, HtxxPlThirdEventService> eventServiceMap;

    public List<HtxxThirdResultModel> event(HtxxThirdParamModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        ArrayList<HtxxThirdResultModel> resultModelList = new ArrayList<HtxxThirdResultModel>();
        log.info("\u7b2c\u4e09\u65b9\u5408\u540c\u4fe1\u606f\u67e5\u8be2lysjList:{}", (Object)JSON.toJSONString((Object)lysjList));
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            HtxxPlThirdEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModelList);
        }
        return resultModelList;
    }
}

