/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.hlw.core.domain.fj.FjEventService;
import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.util.file.FileUtils;
import cn.gtmap.hlw.domain.fj.enums.FjCodeEnum;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Base64;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FjxxViewByFjidEvent
implements FjxxEventService {
    private static Logger logger = LoggerFactory.getLogger(FjxxViewByFjidEvent.class);
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private FjEventService fjEventService;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        FjEventResultModel fjEventResultModel = new FjEventResultModel();
        GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(paramsModel.getFjid());
        if (gxYyFjxx == null) {
            throw new BizException(FjCodeEnum.FJ_ID_NOTEXISTS.getCode(), FjCodeEnum.FJ_ID_NOTEXISTS.getMsg());
        }
        String filePath = this.fjEventService.getFilePath(gxYyFjxx);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new BizException(FjCodeEnum.FJ_FILE_NOTEXISTS.getCode(), FjCodeEnum.FJ_FILE_NOTEXISTS.getMsg());
        }
        resultModel.setFileLength(CommonUtil.formatEmptyValue((Object)file.length()));
        String fileExtension = FileUtils.getMimeType((String)file.getName());
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            int bytesRead;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byte[] fileContent = byteArrayOutputStream.toByteArray();
            String base64String = Base64.getEncoder().encodeToString(fileContent);
            base64String = "data:" + fileExtension + ";base64," + base64String;
            resultModel.setBase64(base64String);
            resultModel.setBytes(fileContent);
        }
        catch (IOException e) {
            throw new BizException((IError)ErrorEnum.SERVICE_ERROR, "\u67e5\u770b\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38");
        }
        resultModel.setFileName(gxYyFjxx.getFjmc());
        resultModel.setFjid(gxYyFjxx.getFjid());
        return fjEventResultModel;
    }
}

