/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.estateplat.register.common.util.PublicUtil;
import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.domain.fj.enums.FjCodeEnum;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FjxxTicketByFjidEvent
implements FjxxEventService {
    private static Logger logger = LoggerFactory.getLogger(FjxxTicketByFjidEvent.class);
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private RedisRepository redisRepository;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(paramsModel.getFjid());
        if (gxYyFjxx == null) {
            throw new BizException((IError)FjCodeEnum.FJ_ID_NOTEXISTS);
        }
        String ticket = PublicUtil.hex32();
        this.redisRepository.set("download_ticket:" + paramsModel.getFjid(), (Object)ticket, 30L);
        resultModel.setTicket(ticket);
        resultModel.setFjid(paramsModel.getFjid());
        return null;
    }
}

