/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyUserRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.gtmap.hlw.core.util.file.FileUtils;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.FileNameUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service
public class FjxxSaveEvent
implements FjxxEventService {
    private static final Logger log = LoggerFactory.getLogger(FjxxSaveEvent.class);
    @Autowired
    GxYyFjxxRepository gxYyFjxxRepository;
    @Autowired
    GxYyFjxmRepository gxYyFjxmRepository;
    @Autowired
    RedisRepository redisRepository;
    @Resource
    private GxYySqxxRepository gxYySqxxRepository;
    @Resource
    private GxYyZdFjRepository gxYyZdFjRepository;
    @Resource
    private GxYyUserRepository gxYyUserRepository;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getFjid())) {
            GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(paramsModel.getFjid());
            if (gxYyFjxx != null && StringUtils.isNotBlank((CharSequence)paramsModel.getBase64())) {
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] bytes = new byte[]{};
                try {
                    bytes = decoder.decodeBuffer(paramsModel.getBase64());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (StringUtils.isBlank((CharSequence)paramsModel.getFileName())) {
                    paramsModel.setFileName(gxYyFjxx.getFjmc());
                }
                String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
                File file = FileUtils.uploadFile((String)(uploadPath + File.separator + gxYyFjxx.getFilepath()), (String)paramsModel.getFileName(), (byte[])bytes);
                gxYyFjxx.setFjmc(paramsModel.getFileName());
                gxYyFjxx.setFilemc(paramsModel.getFileName());
                this.gxYyFjxxRepository.saveOrUpdate(gxYyFjxx);
                paramsModel.setFile(file);
                resultModel.setFjid(gxYyFjxx.getFjid());
                resultModel.setFileName(paramsModel.getFileName());
                resultModel.setFile(new File(uploadPath + File.separator + gxYyFjxx.getFilepath(), paramsModel.getFileName()));
            }
        } else {
            List<GxYyFjxx> gxYyFjxxListTemp;
            Map<String, List<GxYyFjxx>> listMap;
            List gxYyFjxxList;
            GxYyFjxm gxYyFjxm = this.getFjxm(paramsModel);
            if (FjlxEnum.FJLX_RXCJ.getCode().toString().equals(paramsModel.getFjlx()) && CollectionUtils.isNotEmpty((Collection)(gxYyFjxxList = this.gxYyFjxxRepository.getFjxxListBySlbhAndFjlxAndZjh(paramsModel.getSlbh(), paramsModel.getFjlx(), paramsModel.getQlrzjhList()))) && (listMap = gxYyFjxxList.stream().collect(Collectors.groupingBy(GxYyFjxx::getFjmc))).containsKey(paramsModel.getFileName()) && CollectionUtils.isNotEmpty(gxYyFjxxListTemp = listMap.get(paramsModel.getFileName()))) {
                GxYyFjxx gxYyFjxx = gxYyFjxxListTemp.get(0);
                this.uploadFile(paramsModel, gxYyFjxm, gxYyFjxx);
                paramsModel.setFjid(gxYyFjxx.getFjid());
                resultModel.setFjid(gxYyFjxx.getFjid());
                resultModel.setFileName(gxYyFjxx.getFjmc());
                return resultModel;
            }
            if (StringUtils.contains((CharSequence)paramsModel.getFjlx(), (CharSequence)"RXCJ_") && CollectionUtils.isNotEmpty((Collection)(gxYyFjxxList = this.gxYyFjxxRepository.getFjxxBySqidAndFjlx(gxYyFjxm.getSqid(), paramsModel.getFjlx())))) {
                GxYyFjxx gxYyFjxx = (GxYyFjxx)gxYyFjxxList.get(0);
                gxYyFjxx.setFjmc(paramsModel.getFileName());
                gxYyFjxx.setFilemc(paramsModel.getFileName());
                this.uploadFile(paramsModel, gxYyFjxm, gxYyFjxx);
                paramsModel.setFjid(gxYyFjxx.getFjid());
                resultModel.setFjid(gxYyFjxx.getFjid());
                resultModel.setFileName(paramsModel.getFileName());
                return resultModel;
            }
            if (null != gxYyFjxm) {
                List fjxxList;
                GxYySqxx gxYySqxx;
                GxYyFjxx fjxx = new GxYyFjxx();
                fjxx.setXmid(gxYyFjxm.getXmid());
                fjxx.setSqid(StringUtils.isNotBlank((CharSequence)paramsModel.getSqid()) ? paramsModel.getSqid() : gxYyFjxm.getSqid());
                fjxx.setCreateDate(new Date());
                fjxx.setFjlx(StringUtils.isBlank((CharSequence)paramsModel.getFjlx()) ? gxYyFjxm.getFjlx() : paramsModel.getFjlx());
                if (StringUtils.isBlank((CharSequence)fjxx.getFjlx()) && StringUtils.isNotBlank((CharSequence)paramsModel.getFjlxmc())) {
                    String fjlx = this.getZdfjFjlx(paramsModel);
                    fjxx.setFjlx(fjlx);
                }
                fjxx.setCreateUser(SessionUtil.getUser() != null ? SessionUtil.getUser().getUserName() : "");
                String fileName = paramsModel.getFileName();
                fjxx.setFjmc(fileName);
                fjxx.setFilemc(fileName);
                fjxx.setFjid(StringUtil.hex32());
                fjxx.setQlrzjhList(paramsModel.getQlrzjhList());
                fjxx.setFjly(paramsModel.getFjly());
                if (StringUtils.isBlank((CharSequence)paramsModel.getSlbh()) && StringUtils.isNotBlank((CharSequence)paramsModel.getSqid()) && (gxYySqxx = this.gxYySqxxRepository.get(paramsModel.getSqid())) != null) {
                    paramsModel.setSlbh(gxYySqxx.getSlbh());
                }
                if (CollectionUtils.isNotEmpty((Collection)(fjxxList = StringUtils.isNotBlank((CharSequence)fjxx.getXmid()) ? this.gxYyFjxxRepository.getByFjxmid(fjxx.getXmid()) : this.gxYyFjxxRepository.getFjxxListByFjlxAndSqid(fjxx.getFjlx(), fjxx.getSqid())))) {
                    for (GxYyFjxx gxYyFjxx : fjxxList) {
                        if (!StringUtils.equals((CharSequence)gxYyFjxx.getFjmc(), (CharSequence)fjxx.getFjmc())) continue;
                        fjxx.setFjid(gxYyFjxx.getFjid());
                        break;
                    }
                }
                this.uploadFile(paramsModel, gxYyFjxm, fjxx);
                paramsModel.setFjid(fjxx.getFjid());
                resultModel.setFjid(fjxx.getFjid());
                resultModel.setFileName(fjxx.getFjmc());
                resultModel.setFile(paramsModel.getFile());
            }
        }
        return resultModel;
    }

    private void uploadFile(FjEventParamsModel paramsModel, GxYyFjxm gxYyFjxm, GxYyFjxx fjxx) {
        this.checkFileType(fjxx.getFjmc());
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        if (StringUtils.isNotBlank((CharSequence)uploadPath)) {
            String dateToStr = DateUtils.dateToStr((Date)new Date(), (String)DateUtils.DATE_FORMAT_FILE);
            StringBuilder sb = new StringBuilder();
            sb.append(dateToStr).append(File.separator).append(paramsModel.getSlbh()).append(File.separator).append(gxYyFjxm.getXmid()).append(File.separator).append(fjxx.getFjid());
            String filePath = sb.toString();
            String uploadFilePath = uploadPath + File.separator + filePath;
            String path = uploadFilePath + File.separator + fjxx.getFjmc();
            try {
                FileUtil.mkdir((String)uploadFilePath);
                String base64Str = StringUtil.removeBase64Pre((String)paramsModel.getBase64());
                File file = FileUtil.writeBytes((byte[])Base64.decode((CharSequence)base64Str), (String)path);
                paramsModel.setFile(file);
            }
            catch (IORuntimeException e) {
                log.error("uploadFile.error", (Throwable)e);
                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
            fjxx.setFilepath(filePath);
            this.gxYyFjxxRepository.saveOrUpdate(fjxx);
        }
    }

    private void checkFileType(String fjmc) {
        if (StringUtils.isNotBlank((CharSequence)fjmc)) {
            String types;
            String suffix = FileNameUtil.getSuffix((String)fjmc);
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                suffix = suffix.toLowerCase();
            }
            if (StringUtils.isNotBlank((CharSequence)(types = StringUtil.toString((Object)this.redisRepository.get("upload.file.type")))) && !StringUtils.contains((CharSequence)types, (CharSequence)suffix)) {
                throw new BizException((IError)ErrorEnum.ILLEGAL_FILETYPE);
            }
        }
    }

    private String getZdfjFjlx(FjEventParamsModel paramsModel) {
        List zdFjList;
        GxYySqxx gxYySqxx = this.gxYySqxxRepository.get(paramsModel.getSqid());
        if (gxYySqxx != null && CollectionUtils.isNotEmpty((Collection)(zdFjList = this.gxYyZdFjRepository.getZdFjListByFjywAndDjyy(Arrays.asList(gxYySqxx.getSqlx()), null)))) {
            for (GxYyZdFj gxYyZdFj : zdFjList) {
                if (!paramsModel.getFjlxmc().equals(gxYyZdFj.getMc())) continue;
                return gxYyZdFj.getFjlxdm();
            }
        }
        return "";
    }

    private GxYyFjxm getFjxm(FjEventParamsModel paramsModel) {
        GxYyFjxm gxYyFjxm = null;
        if (paramsModel.getGxYyFjxm() != null) {
            gxYyFjxm = paramsModel.getGxYyFjxm();
        } else if (StringUtils.isNotBlank((CharSequence)paramsModel.getFjxmid())) {
            gxYyFjxm = this.gxYyFjxmRepository.get(paramsModel.getFjxmid());
        } else if (StringUtils.isNotBlank((CharSequence)paramsModel.getSlbh()) && StringUtils.isNotBlank((CharSequence)paramsModel.getFjlx())) {
            gxYyFjxm = this.gxYyFjxmRepository.getBySlbhAndFjlx(paramsModel.getSlbh(), paramsModel.getFjlx());
        }
        return gxYyFjxm;
    }
}

