/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.date.DateUtils;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.FileNameUtil;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjxxSaveByFjidEvent
implements FjxxEventService {
    private static final Logger log = LoggerFactory.getLogger(FjxxSaveByFjidEvent.class);
    @Autowired
    GxYyFjxxRepository gxYyFjxxRepository;
    @Autowired
    GxYyFjxmRepository gxYyFjxmRepository;
    @Autowired
    RedisRepository redisRepository;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        GxYyFjxx fjxx = this.gxYyFjxxRepository.get(paramsModel.getFjid());
        if (null == fjxx) {
            throw new BizException((IError)ErrorEnum.NO_DATA);
        }
        GxYyFjxm gxYyFjxm = this.gxYyFjxmRepository.get(fjxx.getXmid());
        paramsModel.setSlbh(gxYyFjxm.getSlbh());
        this.uploadFile(paramsModel, gxYyFjxm, fjxx);
        paramsModel.setFjid(fjxx.getFjid());
        resultModel.setFjid(fjxx.getFjid());
        resultModel.setFileName(fjxx.getFjmc());
        return resultModel;
    }

    private void uploadFile(FjEventParamsModel paramsModel, GxYyFjxm gxYyFjxm, GxYyFjxx fjxx) {
        this.checkFileType(fjxx.getFjmc());
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        if (StringUtils.isNotBlank((CharSequence)uploadPath)) {
            String dateToStr = DateUtils.dateToStr((Date)new Date(), (String)DateUtils.DATE_FORMAT_FILE);
            StringBuilder sb = new StringBuilder();
            sb.append(dateToStr).append(File.separator).append(paramsModel.getSlbh()).append(File.separator).append(gxYyFjxm.getXmid()).append(File.separator).append(fjxx.getFjid());
            String filePath = sb.toString();
            String uploadFilePath = uploadPath + File.separator + filePath;
            String path = uploadFilePath + File.separator + fjxx.getFjmc();
            try {
                FileUtil.mkdir((String)uploadFilePath);
                String base64Str = StringUtil.removeBase64Pre((String)paramsModel.getBase64());
                File file = FileUtil.writeBytes((byte[])Base64.decode((CharSequence)base64Str), (String)path);
                paramsModel.setFile(file);
            }
            catch (IORuntimeException e) {
                log.error("uploadFile.error", (Throwable)e);
                throw new BizException(ErrorEnum.SERVICE_ERROR.getCode(), "\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
            fjxx.setFilepath(filePath);
            this.gxYyFjxxRepository.saveOrUpdate(fjxx);
        }
    }

    private void checkFileType(String fjmc) {
        if (StringUtils.isNotBlank((CharSequence)fjmc)) {
            String types;
            String suffix = FileNameUtil.getSuffix((String)fjmc);
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                suffix = suffix.toLowerCase();
            }
            if (StringUtils.isNotBlank((CharSequence)(types = StringUtil.toString((Object)this.redisRepository.get("upload.file.type")))) && !StringUtils.contains((CharSequence)types, (CharSequence)suffix)) {
                throw new BizException((IError)ErrorEnum.ILLEGAL_FILETYPE);
            }
        }
    }
}

