/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.hlw.core.domain.fj.FjEventService;
import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.domain.fj.enums.FjCodeEnum;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FjxxDownloadByFjidEvent
implements FjxxEventService {
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private RedisRepository redisRepository;
    @Resource
    private FjEventService fjEventService;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        String redisTicket = String.valueOf(this.redisRepository.get("download_ticket:" + paramsModel.getFjid()));
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{redisTicket, paramsModel.getTicket()}) || !StringUtils.equals((CharSequence)redisTicket, (CharSequence)paramsModel.getTicket())) {
            throw new BizException((IError)ErrorEnum.USER_NO_AUTH_FJ);
        }
        GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(paramsModel.getFjid());
        if (gxYyFjxx == null) {
            throw new BizException(FjCodeEnum.FJ_ID_NOTEXISTS.getCode(), FjCodeEnum.FJ_ID_NOTEXISTS.getMsg());
        }
        String filePath = this.fjEventService.getFilePath(gxYyFjxx);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new BizException(FjCodeEnum.FJ_FILE_NOTEXISTS.getCode(), FjCodeEnum.FJ_FILE_NOTEXISTS.getMsg());
        }
        resultModel.setFile(file);
        return resultModel;
    }
}

