/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.fj.enums.FjCodeEnum;
import java.io.File;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FjxxDeleteByFjidEvent
implements FjxxEventService {
    @Resource
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Resource
    private HlwPzPzxRepository hlwPzPzxRepository;
    @Resource
    private RedisRepository redisRepository;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        int num;
        boolean isDelete;
        resultModel.setFjid(paramsModel.getFjid());
        GxYyFjxx gxYyFjxx = this.gxYyFjxxRepository.get(paramsModel.getFjid());
        if (gxYyFjxx == null) {
            throw new BizException(FjCodeEnum.FJ_ID_NOTEXISTS.getCode(), FjCodeEnum.FJ_ID_NOTEXISTS.getMsg());
        }
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        String filePath = uploadPath + File.separator + gxYyFjxx.getFilepath() + File.separator + gxYyFjxx.getFjmc();
        File file = new File(filePath);
        if (file.exists() && (isDelete = file.delete()) && (num = this.gxYyFjxxRepository.delete(paramsModel.getFjid())) > 0) {
            return null;
        }
        throw new BizException(FjCodeEnum.FJ_FILE_DELETE_FAIL.getCode(), FjCodeEnum.FJ_FILE_DELETE_FAIL.getMsg());
    }
}

