/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxx;

import cn.gtmap.hlw.core.domain.fj.FjEventService;
import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.hutool.core.codec.Base64;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjxxCheckXzwjdzEvent
implements FjxxEventService {
    @Autowired
    private GxYyFjxmRepository gxYyFjxmRepository;
    @Autowired
    private GxYyFjxxRepository gxYyFjxxRepository;
    @Autowired
    private FjEventService fjEventService;
    @Autowired
    private GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    private GxYyZdFjRepository gxYyZdFjRepository;

    public FjEventResultModel doWork(FjEventParamsModel paramsModel, FjEventResultModel resultModel) {
        GxYyFjxm gxYyFjxm = this.gxYyFjxmRepository.getBySlbhAndFjlx(paramsModel.getSlbh(), paramsModel.getFjlx());
        if (gxYyFjxm != null) {
            byte[] fileData = Base64.decode((CharSequence)paramsModel.getBase64());
            long fileSize = fileData.length;
            int sl = 1;
            List fjxxList = this.gxYyFjxxRepository.getByFjxmid(gxYyFjxm.getXmid());
            if (CollectionUtils.isNotEmpty((Collection)fjxxList)) {
                for (GxYyFjxx gxYyFjxx : fjxxList) {
                    String filePath = this.fjEventService.getFilePath(gxYyFjxx);
                    File file = new File(filePath);
                    if (!file.exists()) continue;
                    long length = file.length();
                    fileSize += length;
                }
                sl += fjxxList.size();
            }
            GxYySqxx gxYySqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
            GxYyZdFj zdFj = this.gxYyZdFjRepository.getByFjlx(gxYyFjxm.getFjlx(), gxYySqxx.getSqlx());
            if (zdFj != null) {
                String xzwjdx = zdFj.getXzwjdx();
                if (StringUtils.isNotBlank((CharSequence)xzwjdx) && Long.parseLong(xzwjdx) * 1024L * 1024L < fileSize) {
                    throw new BizException(ErrorEnum.FAIL.getCode(), gxYyFjxm.getFjlxmc() + "\u9644\u4ef6\u5927\u5c0f\u8d85\u51fa" + zdFj.getXzwjdx() + "MB,\u8bf7\u6838\u5b9e\u5e76\u8c03\u6574");
                }
                String xzfs = zdFj.getXzfs();
                if (StringUtils.isNotBlank((CharSequence)xzfs) && Integer.parseInt(xzfs) < sl) {
                    throw new BizException(ErrorEnum.FAIL.getCode(), gxYyFjxm.getFjlxmc() + "\u9644\u4ef6\u6570\u91cf\u8d85\u51fa" + zdFj.getXzfs() + ",\u8bf7\u6838\u5b9e\u5e76\u8c03\u6574");
                }
            }
        }
        return null;
    }
}

