/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxm;

import cn.gtmap.hlw.core.domain.fj.FjxmEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjxmEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjxmEventResultModel;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WuHuRxFjxmInitEvent
implements FjxmEventService {
    @Autowired
    GxYyZdFjRepository zdFjRepository;
    @Autowired
    GxYyZdSqlxRepository zdSqlxRepository;
    @Autowired
    GxYyFjxmRepository fjxmRepository;
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Resource
    GxYyQlrRepository gxYyQlrRepository;

    public void doWork(FjxmEventParamsModel paramsModel, List<FjxmEventResultModel> resultModelList) {
        ArrayList fjxmList = Lists.newArrayList();
        GxYySqxx zySqxx = this.sqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
        if (zySqxx == null) {
            return;
        }
        List qlrList = this.gxYyQlrRepository.getBySqidAndQlrlx(zySqxx.getSqid(), QlrTypeEnum.QLRLX_YWR.getCode());
        if (CollectionUtils.isEmpty((Collection)qlrList)) {
            return;
        }
        for (GxYyQlr qlr : qlrList) {
            GxYyFjxm fjxm = new GxYyFjxm();
            fjxm.setSlbh(paramsModel.getSlbh());
            fjxm.setSqid(zySqxx.getSqid());
            fjxm.setXmid(StringUtil.hex32());
            fjxm.setFjlx("RXCJ_" + qlr.getQlrzjh());
            fjxm.setFjlxmc("\u4eba\u50cf\u91c7\u96c6_" + qlr.getQlrzjh() + "_" + qlr.getQlrmc());
            fjxm.setCllx("");
            fjxm.setClfs("1");
            fjxm.setClys("1");
            fjxm.setXh(Integer.valueOf(99));
            fjxmList.add(fjxm);
        }
        if (CollectionUtils.isNotEmpty((Collection)fjxmList)) {
            this.fjxmRepository.insertBatchSomeColumn((List)fjxmList);
        }
    }
}

