/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxm;

import cn.gtmap.hlw.core.domain.fj.FjxmEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjxmEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjxmEventResultModel;
import cn.gtmap.hlw.core.enums.dict.HyztEnum;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.dict.fw.FwtcEnum;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYyJtcy;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyFjxxRepository;
import cn.gtmap.hlw.core.repository.GxYyJtcyRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.session.SessionUtil;
import cn.gtmap.hlw.domain.fj.event.fjxm.FjxxComparator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhFjxmQueryEvent
implements FjxmEventService {
    @Autowired
    GxYyFjxmRepository fjxmRepository;
    @Autowired
    GxYyFjxxRepository fjxxRepository;
    @Autowired
    GxYyZdFjRepository fjRepository;
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    GxYyJtcyRepository gxYyJtcyRepository;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYyQlrRepository gxYyQlrRepository;

    public void doWork(FjxmEventParamsModel paramsModel, List<FjxmEventResultModel> resultModelList) {
        GxYySqxx gxYySqxx = this.gxYySqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
        List fjxmList = this.fjxmRepository.getFjxmOrderByXh(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)fjxmList)) {
            return;
        }
        List<Object> jtcyZjhList = Lists.newArrayList();
        String qlrzjh = SessionUtil.getUser().getUserZjid();
        GxYyJtcy jtcy = this.gxYyJtcyRepository.getByZjh(gxYySqxx.getSqid(), qlrzjh);
        if (jtcy != null) {
            List jtcyList;
            if (StringUtils.equals((CharSequence)jtcy.getJtcyfwtc(), (CharSequence)FwtcEnum.FWTC_QTT.getCode())) {
                fjxmList = fjxmList.stream().filter(gxYyFjxm -> !StringUtils.equals((CharSequence)gxYyFjxm.getFjlx(), (CharSequence)FjlxEnum.FJLX_GFRHKB.getCode().toString()) && !StringUtils.equals((CharSequence)gxYyFjxm.getFjlx(), (CharSequence)FjlxEnum.FJLX_GFRHYZK.getCode().toString())).collect(Collectors.toList());
            }
            if (StringUtils.equals((CharSequence)jtcy.getJtcyhyzt(), (CharSequence)HyztEnum.HYZT_WH.getCode())) {
                fjxmList = fjxmList.stream().filter(gxYyFjxm -> !StringUtils.equals((CharSequence)gxYyFjxm.getFjlx(), (CharSequence)FjlxEnum.FJLX_GFRHYZK.getCode().toString())).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)(jtcyList = this.gxYyJtcyRepository.list(gxYySqxx.getSqid(), jtcy.getJtmc())))) {
                jtcyZjhList = jtcyList.stream().map(GxYyJtcy::getJtcyzjh).collect(Collectors.toList());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getFjlx())) {
            fjxmList = fjxmList.stream().filter(gxYyFjxm -> StringUtils.equals((CharSequence)gxYyFjxm.getFjlx(), (CharSequence)paramsModel.getFjlx())).collect(Collectors.toList());
        }
        List resultModels = BeanConvertUtil.getBeanListByJsonArray((Object)fjxmList, FjxmEventResultModel.class);
        if (StringUtils.isNotBlank((CharSequence)paramsModel.getSqlx())) {
            HashSet sqdjlxSet = Sets.newHashSet();
            sqdjlxSet.add(paramsModel.getSqlx());
            List zdfjList = this.fjRepository.getBySqlx((Set)sqdjlxSet);
            List finalZdfjList = zdfjList = zdfjList.stream().filter(gxYyZdFj -> StringUtils.isBlank((CharSequence)gxYyZdFj.getDjyy()) || StringUtils.isNotBlank((CharSequence)gxYyZdFj.getDjyy()) && Arrays.asList(StringUtils.split((String)gxYyZdFj.getDjyy(), (String)",")).contains(paramsModel.getDjyy())).collect(Collectors.toList());
            resultModels.stream().forEach(resultModel -> finalZdfjList.stream().forEach(zdFj -> {
                if (StringUtils.equals((CharSequence)resultModel.getFjlx(), (CharSequence)zdFj.getFjlxdm())) {
                    resultModel.setFjyz(zdFj.getFjYz());
                    resultModel.setQlrlx(zdFj.getQlrlx());
                }
            }));
        }
        resultModelList.addAll(resultModels);
        ArrayList fjxms = Lists.newArrayList();
        fjxmList.stream().forEach(gxYyFjxm -> fjxms.add(gxYyFjxm.getXmid()));
        List fjxxList = this.fjxxRepository.getByFjxmids((List)fjxms);
        if (CollectionUtils.isEmpty((Collection)fjxxList)) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)jtcyZjhList)) {
            List<Object> finalJtcyZjhList = jtcyZjhList;
            fjxxList = fjxxList.stream().filter(gxYyFjxx -> finalJtcyZjhList.contains(gxYyFjxx.getQlrzjhList()) || StringUtils.isBlank((CharSequence)gxYyFjxx.getQlrzjhList())).collect(Collectors.toList());
        }
        List finalFjxxList = fjxxList;
        resultModelList.stream().forEach(fjxmResultDTO -> finalFjxxList.stream().forEach(gxYyFjxx -> {
            if (StringUtils.equals((CharSequence)fjxmResultDTO.getXmid(), (CharSequence)gxYyFjxx.getXmid())) {
                if (fjxmResultDTO.getFjxxList() == null) {
                    fjxmResultDTO.setFjxxList((List)Lists.newArrayList());
                }
                fjxmResultDTO.getFjxxList().add(gxYyFjxx);
            }
        }));
        this.sxSwwj(paramsModel.getSlbh(), qlrzjh, resultModelList);
        String value = this.hlwPzPzxRepository.getHlwPzPzxValueByPzxKey("yc.fjxx.sort");
        if (StringUtils.equals((CharSequence)value, (CharSequence)"windows")) {
            resultModelList.stream().forEach(fjxmResultDTO -> {
                List sortedFjxxList = null;
                if (fjxmResultDTO.getFjxxList() != null) {
                    sortedFjxxList = fjxmResultDTO.getFjxxList().stream().sorted(FjxxComparator::compareFjxx).collect(Collectors.toList());
                }
                fjxmResultDTO.setFjxxList(sortedFjxxList);
            });
        }
    }

    private void sxSwwj(String slbh, String qlrzjh, List<FjxmEventResultModel> resultModelList) {
        List gxYyQlrList = this.gxYyQlrRepository.getBySlbh(slbh);
        if (CollectionUtils.isEmpty((Collection)gxYyQlrList)) {
            return;
        }
        Optional<GxYyQlr> matchedQlrlxOpt = gxYyQlrList.stream().filter(qlr -> qlrzjh.equals(qlr.getQlrzjh())).filter(qlr -> StringUtils.isNotBlank((CharSequence)qlr.getQlrlx())).findFirst();
        resultModelList.removeIf(fjxm -> StringUtils.isNotBlank((CharSequence)fjxm.getQlrlx()) && !StringUtils.equals((CharSequence)fjxm.getQlrlx(), (CharSequence)matchedQlrlxOpt.map(GxYyQlr::getQlrlx).orElse("")));
        Optional<FjxmEventResultModel> fjxmOpt = resultModelList.stream().filter(model -> "1030".equals(model.getFjlx())).findFirst();
        fjxmOpt.ifPresent(fjxm -> {
            List zjhList = matchedQlrlxOpt.map(qlr -> gxYyQlrList.stream().filter(q -> qlr.getQlrlx().equals(q.getQlrlx())).map(GxYyQlr::getQlrzjh).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (CollectionUtils.isNotEmpty(zjhList) && CollectionUtils.isNotEmpty((Collection)fjxm.getFjxxList())) {
                fjxm.getFjxxList().removeIf(gxYyFjxx -> !zjhList.contains(gxYyFjxx.getQlrzjhList()) && StringUtils.isNotBlank((CharSequence)gxYyFjxx.getQlrzjhList()));
            }
        });
    }

    public static void main(String[] args) {
        String slbh = "SL12345";
        String qlrzjh = "ID001";
        ArrayList<FjxmEventResultModel> resultModelList = new ArrayList<FjxmEventResultModel>();
        FjxmEventResultModel fjxm1 = new FjxmEventResultModel();
        fjxm1.setFjlx("1030");
        fjxm1.setFjxxList(new ArrayList());
        FjxmEventResultModel fjxm2 = new FjxmEventResultModel();
        fjxm2.setFjlx("2040");
        resultModelList.add(fjxm1);
        resultModelList.add(fjxm2);
        ArrayList<GxYyQlr> gxYyQlrList = new ArrayList<GxYyQlr>();
        GxYyQlr qlr1 = new GxYyQlr();
        qlr1.setQlrzjh("ID001");
        qlr1.setQlrlx("1");
        GxYyQlr qlr2 = new GxYyQlr();
        qlr2.setQlrzjh("ID002");
        qlr2.setQlrlx("1");
        GxYyQlr qlr3 = new GxYyQlr();
        qlr3.setQlrzjh("ID003");
        qlr3.setQlrlx("2");
        gxYyQlrList.add(qlr1);
        gxYyQlrList.add(qlr2);
        gxYyQlrList.add(qlr3);
        ArrayList<GxYyFjxx> fjxxList = new ArrayList<GxYyFjxx>();
        GxYyFjxx gxYyFjxx1 = new GxYyFjxx();
        gxYyFjxx1.setQlrzjhList("ID001");
        GxYyFjxx gxYyFjxx2 = new GxYyFjxx();
        gxYyFjxx2.setQlrzjhList("ID002");
        GxYyFjxx gxYyFjxx3 = new GxYyFjxx();
        gxYyFjxx3.setQlrzjhList("ID003");
        fjxxList.add(gxYyFjxx1);
        fjxxList.add(gxYyFjxx2);
        fjxxList.add(gxYyFjxx3);
        fjxm1.setFjxxList(fjxxList);
    }
}

