/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fjxm;

import cn.gtmap.hlw.core.domain.fj.FjxmEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjxmEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjxmEventResultModel;
import cn.gtmap.hlw.core.enums.qlr.QlrTypeEnum;
import cn.gtmap.hlw.core.enums.status.StatusEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyQlr;
import cn.gtmap.hlw.core.model.GxYyQlrJtcy;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import cn.gtmap.hlw.core.model.GxYyZdSqlx;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrJtcyRepository;
import cn.gtmap.hlw.core.repository.GxYyQlrRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjxmInitEvent
implements FjxmEventService {
    @Autowired
    GxYyZdFjRepository zdFjRepository;
    @Autowired
    GxYyZdSqlxRepository zdSqlxRepository;
    @Autowired
    GxYyFjxmRepository fjxmRepository;
    @Autowired
    GxYySqxxRepository sqxxRepository;
    @Autowired
    GxYyQlrRepository qlrRepository;
    @Autowired
    GxYyQlrJtcyRepository jtcyRepository;
    private static final String FJML_QLR = "{{qlr}}";
    private static final String FJML_YWR = "{{ywr}}";
    private static final String FJML_QLR_JTCY = "{{qlrjtcy}}";
    private static final String FJML_YWR_JTCY = "{{ywrjtcy}}";

    public void doWork(FjxmEventParamsModel paramsModel, List<FjxmEventResultModel> resultModelList) {
        FjxmEventParamsModel initParams = (FjxmEventParamsModel)BeanConvertUtil.getBeanByJsonObj((Object)paramsModel, FjxmEventParamsModel.class);
        ArrayList fjxmList = Lists.newArrayList();
        List<GxYyZdFj> zdFjList = this.getZdFjList(initParams);
        GxYySqxx zySqxx = this.sqxxRepository.getSqxxOneBySlbh(paramsModel.getSlbh());
        List sqxxList = this.sqxxRepository.list(paramsModel.getSlbh());
        if (CollectionUtils.isEmpty((Collection)sqxxList) || zySqxx == null) {
            return;
        }
        for (GxYySqxx sqxx : sqxxList) {
            if (!CollectionUtils.isNotEmpty(zdFjList)) continue;
            Iterator<GxYyZdFj> it = zdFjList.iterator();
            while (it.hasNext()) {
                GxYyZdFj gxYyZdFj = it.next();
                GxYyFjxm fjxm = new GxYyFjxm();
                fjxm.setSlbh(paramsModel.getSlbh());
                if (StringUtils.equals((CharSequence)sqxx.getSqdjlx(), (CharSequence)gxYyZdFj.getFjYw())) {
                    fjxm.setSqid(sqxx.getSqid());
                } else {
                    if (!StringUtils.equals((CharSequence)sqxx.getSqlx(), (CharSequence)gxYyZdFj.getFjYw())) continue;
                    fjxm.setSqid(zySqxx.getSqid());
                }
                fjxm.setXmid(StringUtil.hex32());
                fjxm.setFjlx(String.valueOf(gxYyZdFj.getFjlxdm()));
                fjxm.setFjlxmc(this.getFjml(gxYyZdFj.getMc(), paramsModel.getSlbh()));
                fjxm.setCllx(gxYyZdFj.getMrfjlx());
                fjxm.setClfs(gxYyZdFj.getMrfjfs());
                fjxm.setClys(gxYyZdFj.getMrfjys());
                fjxm.setXh(gxYyZdFj.getXh());
                fjxm.setPushsyslist(gxYyZdFj.getPushsyslist());
                fjxm.setQlrlx(gxYyZdFj.getQlrlx());
                fjxm.setFjyc(gxYyZdFj.getFjYc());
                fjxmList.add(fjxm);
                it.remove();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)fjxmList)) {
            this.fjxmRepository.insertBatchSomeColumn((List)fjxmList);
        }
    }

    private List<GxYyZdFj> getZdFjList(FjxmEventParamsModel paramsModel) {
        List zdFjList;
        GxYyZdSqlx sqlx = this.zdSqlxRepository.getSqlxBySqlxdm(paramsModel.getSqlx());
        if (sqlx == null) {
            throw new BizException(ApplyCodeEnum.APPLY_SQLX_NULL.getCode(), ApplyCodeEnum.APPLY_SQLX_NULL.getMsg());
        }
        HashSet sqlxs = Sets.newHashSet();
        sqlxs.add(paramsModel.getSqlx());
        boolean isZh = StringUtils.equals((CharSequence)StatusEnum.TRUE.getCode(), (CharSequence)sqlx.getSfzh());
        if (isZh) {
            List sqlxList = this.zdSqlxRepository.getZsqlxBySubdm(paramsModel.getSqlx());
            sqlxList.forEach(gxYyZdSqlx -> sqlxs.add(gxYyZdSqlx.getDm()));
        }
        if (CollectionUtils.isEmpty((Collection)(zdFjList = this.zdFjRepository.getZdFjListByFjywAndDjyy(new ArrayList(sqlxs), null)))) {
            throw new BizException(ApplyCodeEnum.APPLY_FJ_NULL.getCode(), ApplyCodeEnum.APPLY_FJ_NULL.getMsg());
        }
        Iterator it2 = zdFjList.iterator();
        while (it2.hasNext()) {
            GxYyZdFj fjxm2 = (GxYyZdFj)it2.next();
            if (!StringUtils.isNotBlank((CharSequence)paramsModel.getDjyy()) || !StringUtils.isNotBlank((CharSequence)fjxm2.getDjyy()) || Arrays.asList(StringUtils.split((String)fjxm2.getDjyy(), (String)",")).contains(paramsModel.getDjyy())) continue;
            it2.remove();
        }
        List fjxmList = this.fjxmRepository.getBySlbh(paramsModel.getSlbh());
        Iterator it = zdFjList.iterator();
        while (it.hasNext()) {
            GxYyZdFj fjxm = (GxYyZdFj)it.next();
            if (!CollectionUtils.isNotEmpty((Collection)fjxmList)) continue;
            for (GxYyFjxm gxYyFjxm : fjxmList) {
                if (!StringUtils.equals((CharSequence)fjxm.getFjlxdm(), (CharSequence)gxYyFjxm.getFjlx()) || !zdFjList.contains(fjxm)) continue;
                it.remove();
            }
        }
        return zdFjList;
    }

    private String getFjml(String fjml, String slbh) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (StringUtils.contains((CharSequence)fjml, (CharSequence)FJML_QLR)) {
            values.put(FJML_QLR, this.getQlrNames(slbh, QlrTypeEnum.QLRLX_QLR.getCode()));
        }
        if (StringUtils.contains((CharSequence)fjml, (CharSequence)FJML_YWR)) {
            values.put(FJML_YWR, this.getQlrNames(slbh, QlrTypeEnum.QLRLX_YWR.getCode()));
        }
        if (StringUtils.contains((CharSequence)fjml, (CharSequence)FJML_QLR_JTCY)) {
            values.put(FJML_QLR_JTCY, this.getJtcyNames(slbh, QlrTypeEnum.QLRLX_QLR.getCode()));
        }
        if (StringUtils.contains((CharSequence)fjml, (CharSequence)FJML_YWR_JTCY)) {
            values.put(FJML_YWR_JTCY, this.getJtcyNames(slbh, QlrTypeEnum.QLRLX_YWR.getCode()));
        }
        return this.replacePlaceholders(fjml, values);
    }

    private String replacePlaceholders(String template, Map<String, String> values) {
        Pattern pattern = Pattern.compile("\\{\\{.*?\\}\\}");
        Matcher matcher = pattern.matcher(template);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String keyWithBraces = matcher.group();
            String replacement = values.getOrDefault(keyWithBraces, "");
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String getQlrNames(String slbh, String qlrlx) {
        return this.qlrRepository.getBySlbhAndQlrlx(slbh, qlrlx).stream().map(GxYyQlr::getQlrmc).filter(StringUtils::isNotBlank).collect(Collectors.toSet()).stream().collect(Collectors.joining(","));
    }

    private String getJtcyNames(String slbh, String qlrlx) {
        HashSet<String> names = new HashSet<String>();
        List qlrList = this.qlrRepository.getBySlbhAndQlrlx(slbh, qlrlx);
        for (GxYyQlr qlr : qlrList) {
            List jtcyList = this.jtcyRepository.getJtcyList(qlr.getQlrid());
            for (GxYyQlrJtcy jtcy : jtcyList) {
                if (!StringUtils.isNotBlank((CharSequence)jtcy.getJtcymc())) continue;
                names.add(jtcy.getJtcymc());
            }
        }
        return String.join((CharSequence)",", names);
    }
}

