/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event.fj;

import cn.gtmap.hlw.core.domain.fj.FjEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.dict.fj.FjlxEnum;
import cn.gtmap.hlw.core.enums.dict.fj.FjlyEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.exception.IError;
import cn.gtmap.hlw.core.model.GxYyFjxm;
import cn.gtmap.hlw.core.model.GxYyFjxx;
import cn.gtmap.hlw.core.model.GxYySqxx;
import cn.gtmap.hlw.core.model.GxYyZdFj;
import cn.gtmap.hlw.core.repository.GxYyFjxmRepository;
import cn.gtmap.hlw.core.repository.GxYySqxxRepository;
import cn.gtmap.hlw.core.repository.GxYyZdFjRepository;
import cn.gtmap.hlw.core.repository.GxYyZdSqlxRepository;
import cn.gtmap.hlw.core.repository.RedisRepository;
import cn.gtmap.hlw.core.util.string.StringUtil;
import cn.gtmap.hlw.domain.fj.event.fjxx.FjxxSaveEvent;
import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FjEventServiceImpl
implements FjEventService {
    private static final Logger log = LoggerFactory.getLogger(FjEventServiceImpl.class);
    @Autowired
    GxYyFjxmRepository fjxmRepository;
    @Autowired
    GxYyZdFjRepository zdFjRepository;
    @Autowired
    FjxxSaveEvent fjxxSaveEvent;
    @Autowired
    GxYySqxxRepository gxYySqxxRepository;
    @Autowired
    GxYyZdSqlxRepository gxYyZdSqlxRepository;
    @Autowired
    RedisRepository redisRepository;

    public FjEventResultModel uploadFileFromBase64(String base64, String sqid, String fjlx, String fjmc, String slbh, String fjly, String qlrzjhList) {
        if (StringUtils.isBlank((CharSequence)base64)) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u751f\u6210" + fjmc + "\u6587\u4ef6\u4e0a\u4f20base64\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)sqid) && StringUtils.isEmpty((CharSequence)slbh)) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u7533\u8bf7id\u6216\u53d7\u7406\u7f16\u53f7\u4e3a\u7a7a");
        }
        GxYySqxx gxYySqxx = null;
        gxYySqxx = StringUtils.isEmpty((CharSequence)sqid) ? this.getSqxx(slbh, fjlx) : this.gxYySqxxRepository.get(sqid);
        if (gxYySqxx == null) {
            log.info("\u6839\u636eslbh:{},\u6216sqid\uff1a{}\u672a\u67e5\u8be2\u5230\u6539\u7533\u8bf7\u4fe1\u606f");
            gxYySqxx = new GxYySqxx();
            gxYySqxx.setSlbh(slbh);
            gxYySqxx.setSqid(sqid);
        }
        FjEventResultModel resultModel = this.saveFjxm(gxYySqxx, fjlx, base64, fjmc, fjly, qlrzjhList);
        return resultModel;
    }

    public String getFilePath(GxYyFjxx fjxx) {
        String uploadPath = StringUtil.toString((Object)this.redisRepository.get("upload.path"));
        StringBuilder builder = new StringBuilder();
        builder.append(uploadPath).append(File.separator).append(fjxx.getFilepath()).append(File.separator).append(fjxx.getFjmc());
        return builder.toString();
    }

    public String getBase64(GxYyFjxx fjxx) {
        String filePath = this.getFilePath(fjxx);
        File file = new File(filePath);
        if (file.exists()) {
            return Base64.encode((File)file);
        }
        return null;
    }

    private FjEventResultModel saveFjxm(GxYySqxx gxYySqxx, String fjlx, String base64, String fjmc, String fjly, String qlrzjhList) {
        GxYyFjxm fjxm = this.fjxmRepository.getBySlbhAndFjlx(gxYySqxx.getSlbh(), fjlx);
        if (null == fjxm) {
            List sqlxList;
            GxYyZdFj gxYyZdFj;
            fjxm = new GxYyFjxm();
            fjxm.setSlbh(gxYySqxx.getSlbh());
            fjxm.setXmid(StringUtil.hex32());
            fjxm.setSqid(gxYySqxx.getSqid());
            fjxm.setFjlx(fjlx);
            fjxm.setFjlxmc(FjlxEnum.getMsg((String)fjlx));
            if (StringUtils.isNotBlank((CharSequence)gxYySqxx.getSqlx()) && (gxYyZdFj = this.zdFjRepository.getBySqlxListAndFjlx(sqlxList = this.gxYyZdSqlxRepository.getSqlxListBySqlx(gxYySqxx.getSqlx()), fjlx)) != null) {
                fjxm.setFjlxmc(gxYyZdFj.getMc());
                fjxm.setCllx(gxYyZdFj.getMrfjlx());
                fjxm.setClfs(gxYyZdFj.getMrfjfs());
                fjxm.setClys(gxYyZdFj.getMrfjys());
            }
            this.fjxmRepository.save(fjxm);
        }
        FjEventParamsModel paramsModel = new FjEventParamsModel();
        paramsModel.setBase64(base64);
        paramsModel.setSqid(gxYySqxx.getSqid());
        paramsModel.setSlbh(gxYySqxx.getSlbh());
        paramsModel.setFjxmid(fjxm.getXmid());
        paramsModel.setFjlx(fjlx);
        paramsModel.setFileName(fjmc);
        paramsModel.setGxYyFjxm(fjxm);
        paramsModel.setQlrzjhList(qlrzjhList);
        paramsModel.setFjly(StringUtils.isNotBlank((CharSequence)fjly) ? fjly : FjlyEnum.FJLY_SDSC.getDm());
        FjEventResultModel resultModel = new FjEventResultModel();
        this.fjxxSaveEvent.doWork(paramsModel, resultModel);
        return resultModel;
    }

    private GxYySqxx getSqxx(String slbhParam, String fjlx) {
        GxYySqxx result = null;
        List gxYySqxxList = this.gxYySqxxRepository.list(slbhParam);
        if (CollectionUtils.isNotEmpty((Collection)gxYySqxxList)) {
            Set sqdjlxList = gxYySqxxList.stream().map(GxYySqxx::getSqdjlx).collect(Collectors.toSet());
            sqdjlxList.addAll(gxYySqxxList.stream().map(GxYySqxx::getSqlx).collect(Collectors.toSet()));
            GxYyZdFj gxYyZdFj = this.zdFjRepository.getBySqlxListAndFjlx(new ArrayList(sqdjlxList), fjlx);
            if (gxYyZdFj == null) {
                throw new BizException((IError)ErrorEnum.NOT_FOUND, "\u672a\u67e5\u8be2\u5230\u9644\u4ef6\u5b57\u5178\u914d\u7f6e,\u7533\u8bf7\u7c7b\u578b:" + JSON.toJSONString(sqdjlxList) + "\uff0c\u9644\u4ef6\u7c7b\u578b\u4ee3\u7801\uff1a" + fjlx);
            }
            for (GxYySqxx sqxx : gxYySqxxList) {
                if (!StringUtils.equals((CharSequence)sqxx.getSqlx(), (CharSequence)gxYyZdFj.getFjYw()) && !StringUtils.equals((CharSequence)sqxx.getSqdjlx(), (CharSequence)gxYyZdFj.getFjYw())) continue;
                result = sqxx;
                break;
            }
        }
        return result;
    }
}

