/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event;

import cn.gtmap.hlw.core.domain.fj.FjxxEventService;
import cn.gtmap.hlw.core.domain.fj.model.FjEventParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FjEventResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FjxxDomainService {
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    private Map<String, FjxxEventService> eventServiceMap;

    public FjEventResultModel event(FjEventParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getCode(), ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getMsg());
        }
        LysjModel lysjList = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId());
        if (lysjList == null || CollectionUtils.isEmpty((Collection)lysjList.getLydzList())) {
            throw new BizException(ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getCode(), ErrorEnum.LYSJ_LYDZ_EMPTY_ERR.getMsg());
        }
        FjEventResultModel resultModel = new FjEventResultModel();
        for (GxYyLydz lydz : lysjList.getLydzList()) {
            FjxxEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            eventService.doWork(paramsModel, resultModel);
        }
        return resultModel;
    }
}

