/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event;

import cn.gtmap.hlw.core.domain.fj.FjThirdDownloadEventService;
import cn.gtmap.hlw.core.domain.fj.model.FileThirdDownloadParamsModel;
import cn.gtmap.hlw.core.domain.fj.model.FileThirdDownloadResultModel;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FjThirdDownloadDomainService {
    private static final Logger log = LoggerFactory.getLogger(FjThirdDownloadDomainService.class);
    @Autowired
    GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Autowired
    private Map<String, FjThirdDownloadEventService> eventServiceMap;

    public FileThirdDownloadResultModel event(FileThirdDownloadParamsModel paramsModel) {
        log.info("\u7b2c\u4e09\u65b9\u9644\u4ef6\u4e0b\u8f7d\u5165\u53c2\uff1a{}", (Object)paramsModel);
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getJddm(), paramsModel.getAnid(), paramsModel.getSqlx());
        if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        FileThirdDownloadParamsModel params = (FileThirdDownloadParamsModel)BeanConvertUtil.getBeanByJsonObj((Object)paramsModel, FileThirdDownloadParamsModel.class);
        FileThirdDownloadResultModel resultModel = new FileThirdDownloadResultModel();
        try {
            log.info("\u7b2c\u4e09\u65b9\u9644\u4ef6\u4e0b\u8f7d\u52a8\u4f5c\uff1a{}", (Object)JSON.toJSONString((Object)lysjModel.getLydzList()));
            for (GxYyLydz lydz : lysjModel.getLydzList()) {
                FjThirdDownloadEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
                eventService.doWork(params, resultModel);
            }
        }
        catch (BizException b) {
            throw b;
        }
        catch (Exception e) {
            log.error("\u7b2c\u4e09\u65b9\u9644\u4ef6\u4e0b\u8f7d\u9519\u8bef\uff1a", (Throwable)e);
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return resultModel;
    }

    private List<GxYyLydz> getProcessLydz(FileThirdDownloadParamsModel paramsModel) {
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return lysjModel.getLydzList();
    }

    private List<GxYyLydz> getJdxxLydz(FileThirdDownloadParamsModel paramsModel) {
        JdxxLysjModel jdxxLysjModel = this.sqlxJdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm(), paramsModel.getAnid());
        if (jdxxLysjModel == null || CollectionUtils.isEmpty((Collection)jdxxLysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return jdxxLysjModel.getLydzList();
    }
}

