/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event;

import cn.gtmap.hlw.core.domain.sqxx.GeneratePdfEventService;
import cn.gtmap.hlw.core.domain.sqxx.model.pdf.GeneratePdfResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.model.query.GeneratePdfEventResultModel;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FjJdxxGeneratePdfDomainService {
    private static final Logger log = LoggerFactory.getLogger(FjJdxxGeneratePdfDomainService.class);
    @Autowired
    GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Autowired
    GxYySqlxJdxxZtRepository gxYySqlxJdxxZtRepository;
    @Autowired
    private Map<String, GeneratePdfEventService> eventServiceMap;

    public List<GeneratePdfResultModel> event(GeneratePdfParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List<Object> lydzList = Lists.newArrayList();
        lydzList = StringUtils.isNotBlank((CharSequence)paramsModel.getProcessId()) ? this.getProcessLydz(paramsModel) : this.getJdxxLydz(paramsModel);
        GeneratePdfParamsModel params = (GeneratePdfParamsModel)BeanConvertUtil.getBeanByJsonObj((Object)paramsModel, GeneratePdfParamsModel.class);
        ArrayList resultModelList = Lists.newArrayList();
        List<String> lydzFjlxList = this.getLydzFjlxList((List<GxYyLydz>)lydzList);
        params.setLydzFjlxList(lydzFjlxList);
        try {
            this.gxYySqlxJdxxZtRepository.updateToExecute(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1003.getCode());
            for (GxYyLydz gxYyLydz : lydzList) {
                GeneratePdfEventService eventService = this.eventServiceMap.get(gxYyLydz.getLydzsxl());
                GeneratePdfEventResultModel pdfEventResultModel = eventService.doWork(params, (List)resultModelList);
                if (pdfEventResultModel == null || !pdfEventResultModel.getSfzd().booleanValue()) continue;
                log.info("\u7531\u4e8e\u9886\u57df\u52a8\u4f5c{}\u901a\u77e5\uff0c\u540e\u7eed\u52a8\u4f5c\u5df2\u7ec8\u6b62\u6267\u884c", (Object)gxYyLydz.getLydzsxl());
                break;
            }
            this.gxYySqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1003.getCode());
        }
        catch (Exception e) {
            log.error("\u7533\u8bf7\u4fe1\u606f\u63d0\u4ea4\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            this.gxYySqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1003.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return resultModelList;
    }

    private List<GxYyLydz> getProcessLydz(GeneratePdfParamsModel paramsModel) {
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return lysjModel.getLydzList();
    }

    private List<String> getLydzFjlxList(List<GxYyLydz> lydzList) {
        ArrayList lydzFjlxList = Lists.newArrayList();
        for (GxYyLydz lydz : lydzList) {
            GeneratePdfEventService eventService = this.eventServiceMap.get(lydz.getLydzsxl());
            if (eventService == null || !StringUtils.isNotBlank((CharSequence)eventService.getEventFjlx())) continue;
            lydzFjlxList.add(eventService.getEventFjlx());
        }
        return lydzFjlxList;
    }

    private List<GxYyLydz> getJdxxLydz(GeneratePdfParamsModel paramsModel) {
        JdxxLysjModel jdxxLysjModel = this.sqlxJdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm());
        if (jdxxLysjModel == null || CollectionUtils.isEmpty((Collection)jdxxLysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return jdxxLysjModel.getLydzList();
    }
}

