/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.domain.fj.event;

import cn.gtmap.hlw.core.domain.sqxx.DypzService;
import cn.gtmap.hlw.core.domain.sqxx.model.pdf.GeneratePdfResultModel;
import cn.gtmap.hlw.core.enums.JddmEnum;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.model.GxYyLydz;
import cn.gtmap.hlw.core.model.JdxxLysjModel;
import cn.gtmap.hlw.core.model.LysjModel;
import cn.gtmap.hlw.core.model.query.GeneratePdfParamsModel;
import cn.gtmap.hlw.core.repository.GxYyLysjRepository;
import cn.gtmap.hlw.core.repository.GxYyProcessLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxLysjRelRepository;
import cn.gtmap.hlw.core.repository.GxYySqlxJdxxZtRepository;
import cn.gtmap.hlw.domain.sqxx.enums.ApplyCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FjGeneratePdfPrintBySqlDomainService {
    private static final Logger log = LoggerFactory.getLogger(FjGeneratePdfPrintBySqlDomainService.class);
    @Autowired
    GxYyProcessLysjRelRepository gxYyProcessLysjRelRepository;
    @Autowired
    GxYyLysjRepository lysjRepository;
    @Autowired
    GxYySqlxJdxxLysjRelRepository sqlxJdxxLysjRelRepository;
    @Autowired
    GxYySqlxJdxxZtRepository gxYySqlxJdxxZtRepository;
    @Resource
    private Map<String, DypzService> eventServiceMap;
    private static final String LYDZJKL_DYPZ = "dypzServiceImpl";

    public List<GeneratePdfResultModel> event(GeneratePdfParamsModel paramsModel) {
        if (StringUtils.isBlank((CharSequence)paramsModel.getLysjdm())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYSJ_NULL.getCode(), ApplyCodeEnum.APPLY_LYSJ_NULL.getMsg());
        }
        List<Object> lydzList = Lists.newArrayList();
        lydzList = StringUtils.isNotBlank((CharSequence)paramsModel.getProcessId()) ? this.getProcessLydz(paramsModel) : (StringUtils.isNotBlank((CharSequence)paramsModel.getJddm()) ? this.getJdxxLydz(paramsModel) : this.getProcessLydz(paramsModel));
        ArrayList resultModelList = Lists.newArrayList();
        try {
            this.gxYySqlxJdxxZtRepository.updateToExecute(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1003.getCode());
            for (GxYyLydz gxYyLydz : lydzList) {
                GeneratePdfResultModel generatePdfResultModel = null;
                DypzService eventService = this.eventServiceMap.get(gxYyLydz.getLydzsxl());
                if (eventService != null) {
                    generatePdfResultModel = eventService.doWork(paramsModel, gxYyLydz.getLydzsxl(), gxYyLydz.getLydzmc());
                } else {
                    eventService = this.eventServiceMap.get(LYDZJKL_DYPZ);
                    generatePdfResultModel = eventService.doWork(paramsModel, gxYyLydz.getLydzsxl(), gxYyLydz.getLydzmc());
                }
                if (generatePdfResultModel == null) continue;
                resultModelList.add(generatePdfResultModel);
            }
            this.gxYySqlxJdxxZtRepository.updateToSucess(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1003.getCode());
        }
        catch (Exception e) {
            this.gxYySqlxJdxxZtRepository.updateFaill(paramsModel.getSlbh(), JddmEnum.JDDM_BDJS_1003.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
            log.error("\u7533\u8bf7\u4fe1\u606f\u63d0\u4ea4\u4e8b\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            throw new BizException(ErrorEnum.LYSJ_ERR.getCode(), "\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return resultModelList;
    }

    private List<GxYyLydz> getProcessLydz(GeneratePdfParamsModel paramsModel) {
        LysjModel lysjModel = this.lysjRepository.queryLysjAndLydz(paramsModel.getLysjdm(), paramsModel.getProcessId(), paramsModel.getAnid());
        if (lysjModel == null || CollectionUtils.isEmpty((Collection)lysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return lysjModel.getLydzList();
    }

    private List<GxYyLydz> getJdxxLydz(GeneratePdfParamsModel paramsModel) {
        JdxxLysjModel jdxxLysjModel = this.sqlxJdxxLysjRelRepository.queryLysjAndLydz(paramsModel.getJddm(), paramsModel.getSqlx(), paramsModel.getLysjdm(), paramsModel.getAnid());
        if (jdxxLysjModel == null || CollectionUtils.isEmpty((Collection)jdxxLysjModel.getLydzList())) {
            throw new BizException(ApplyCodeEnum.APPLY_LYDZ_NULL.getCode(), ApplyCodeEnum.APPLY_LYDZ_NULL.getMsg());
        }
        return jdxxLysjModel.getLydzList();
    }
}

